/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.elasticbeanstalk.model.transform;

import com.amazonaws.services.elasticbeanstalk.model.ResourceQuotas;
import com.amazonaws.services.elasticbeanstalk.model.transform.ResourceQuotaStaxUnmarshaller;
import com.amazonaws.transform.StaxUnmarshallerContext;
import com.amazonaws.transform.Unmarshaller;
import javax.xml.stream.events.XMLEvent;

public class ResourceQuotasStaxUnmarshaller
implements Unmarshaller<ResourceQuotas, StaxUnmarshallerContext> {
    private static ResourceQuotasStaxUnmarshaller instance;

    @Override
    public ResourceQuotas unmarshall(StaxUnmarshallerContext context) throws Exception {
        ResourceQuotas resourceQuotas = new ResourceQuotas();
        int originalDepth = context.getCurrentDepth();
        int targetDepth = originalDepth + 1;
        if (context.isStartOfDocument()) {
            ++targetDepth;
        }
        while (true) {
            XMLEvent xmlEvent;
            if ((xmlEvent = context.nextEvent()).isEndDocument()) {
                return resourceQuotas;
            }
            if (xmlEvent.isAttribute() || xmlEvent.isStartElement()) {
                if (context.testExpression("ApplicationQuota", targetDepth)) {
                    resourceQuotas.setApplicationQuota(ResourceQuotaStaxUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (context.testExpression("ApplicationVersionQuota", targetDepth)) {
                    resourceQuotas.setApplicationVersionQuota(ResourceQuotaStaxUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (context.testExpression("EnvironmentQuota", targetDepth)) {
                    resourceQuotas.setEnvironmentQuota(ResourceQuotaStaxUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (context.testExpression("ConfigurationTemplateQuota", targetDepth)) {
                    resourceQuotas.setConfigurationTemplateQuota(ResourceQuotaStaxUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (!context.testExpression("CustomPlatformQuota", targetDepth)) continue;
                resourceQuotas.setCustomPlatformQuota(ResourceQuotaStaxUnmarshaller.getInstance().unmarshall(context));
                continue;
            }
            if (xmlEvent.isEndElement() && context.getCurrentDepth() < originalDepth) break;
        }
        return resourceQuotas;
    }

    public static ResourceQuotasStaxUnmarshaller getInstance() {
        if (instance == null) {
            instance = new ResourceQuotasStaxUnmarshaller();
        }
        return instance;
    }
}

