/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.elasticbeanstalk.model.transform;

import com.amazonaws.services.elasticbeanstalk.model.ResourceQuota;
import com.amazonaws.transform.SimpleTypeStaxUnmarshallers;
import com.amazonaws.transform.StaxUnmarshallerContext;
import com.amazonaws.transform.Unmarshaller;
import javax.xml.stream.events.XMLEvent;

public class ResourceQuotaStaxUnmarshaller
implements Unmarshaller<ResourceQuota, StaxUnmarshallerContext> {
    private static ResourceQuotaStaxUnmarshaller instance;

    @Override
    public ResourceQuota unmarshall(StaxUnmarshallerContext context) throws Exception {
        ResourceQuota resourceQuota = new ResourceQuota();
        int originalDepth = context.getCurrentDepth();
        int targetDepth = originalDepth + 1;
        if (context.isStartOfDocument()) {
            ++targetDepth;
        }
        while (true) {
            XMLEvent xmlEvent;
            if ((xmlEvent = context.nextEvent()).isEndDocument()) {
                return resourceQuota;
            }
            if (xmlEvent.isAttribute() || xmlEvent.isStartElement()) {
                if (!context.testExpression("Maximum", targetDepth)) continue;
                resourceQuota.setMaximum(SimpleTypeStaxUnmarshallers.IntegerStaxUnmarshaller.getInstance().unmarshall(context));
                continue;
            }
            if (xmlEvent.isEndElement() && context.getCurrentDepth() < originalDepth) break;
        }
        return resourceQuota;
    }

    public static ResourceQuotaStaxUnmarshaller getInstance() {
        if (instance == null) {
            instance = new ResourceQuotaStaxUnmarshaller();
        }
        return instance;
    }
}

