/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.elasticbeanstalk.model.transform;

import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.SdkClientException;
import com.amazonaws.http.HttpMethodName;
import com.amazonaws.internal.SdkInternalList;
import com.amazonaws.services.elasticbeanstalk.model.DescribeEnvironmentsRequest;
import com.amazonaws.transform.Marshaller;
import com.amazonaws.util.StringUtils;

public class DescribeEnvironmentsRequestMarshaller
implements Marshaller<Request<DescribeEnvironmentsRequest>, DescribeEnvironmentsRequest> {
    @Override
    public Request<DescribeEnvironmentsRequest> marshall(DescribeEnvironmentsRequest describeEnvironmentsRequest) {
        if (describeEnvironmentsRequest == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest<DescribeEnvironmentsRequest> request = new DefaultRequest<DescribeEnvironmentsRequest>(describeEnvironmentsRequest, "AWSElasticBeanstalk");
        request.addParameter("Action", "DescribeEnvironments");
        request.addParameter("Version", "2010-12-01");
        request.setHttpMethod(HttpMethodName.POST);
        if (describeEnvironmentsRequest.getApplicationName() != null) {
            request.addParameter("ApplicationName", StringUtils.fromString(describeEnvironmentsRequest.getApplicationName()));
        }
        if (describeEnvironmentsRequest.getVersionLabel() != null) {
            request.addParameter("VersionLabel", StringUtils.fromString(describeEnvironmentsRequest.getVersionLabel()));
        }
        if (!describeEnvironmentsRequest.getEnvironmentIds().isEmpty() || !((SdkInternalList)describeEnvironmentsRequest.getEnvironmentIds()).isAutoConstruct()) {
            SdkInternalList environmentIdsList = (SdkInternalList)describeEnvironmentsRequest.getEnvironmentIds();
            int environmentIdsListIndex = 1;
            for (String environmentIdsListValue : environmentIdsList) {
                if (environmentIdsListValue != null) {
                    request.addParameter("EnvironmentIds.member." + environmentIdsListIndex, StringUtils.fromString(environmentIdsListValue));
                }
                ++environmentIdsListIndex;
            }
        }
        if (!describeEnvironmentsRequest.getEnvironmentNames().isEmpty() || !((SdkInternalList)describeEnvironmentsRequest.getEnvironmentNames()).isAutoConstruct()) {
            SdkInternalList environmentNamesList = (SdkInternalList)describeEnvironmentsRequest.getEnvironmentNames();
            int environmentNamesListIndex = 1;
            for (String environmentNamesListValue : environmentNamesList) {
                if (environmentNamesListValue != null) {
                    request.addParameter("EnvironmentNames.member." + environmentNamesListIndex, StringUtils.fromString(environmentNamesListValue));
                }
                ++environmentNamesListIndex;
            }
        }
        if (describeEnvironmentsRequest.getIncludeDeleted() != null) {
            request.addParameter("IncludeDeleted", StringUtils.fromBoolean(describeEnvironmentsRequest.getIncludeDeleted()));
        }
        if (describeEnvironmentsRequest.getIncludedDeletedBackTo() != null) {
            request.addParameter("IncludedDeletedBackTo", StringUtils.fromDate(describeEnvironmentsRequest.getIncludedDeletedBackTo()));
        }
        if (describeEnvironmentsRequest.getMaxRecords() != null) {
            request.addParameter("MaxRecords", StringUtils.fromInteger(describeEnvironmentsRequest.getMaxRecords()));
        }
        if (describeEnvironmentsRequest.getNextToken() != null) {
            request.addParameter("NextToken", StringUtils.fromString(describeEnvironmentsRequest.getNextToken()));
        }
        return request;
    }
}

