/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.elasticbeanstalk.model.transform;

import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.SdkClientException;
import com.amazonaws.http.HttpMethodName;
import com.amazonaws.internal.SdkInternalList;
import com.amazonaws.services.elasticbeanstalk.model.ConfigurationOptionSetting;
import com.amazonaws.services.elasticbeanstalk.model.CreatePlatformVersionRequest;
import com.amazonaws.services.elasticbeanstalk.model.S3Location;
import com.amazonaws.transform.Marshaller;
import com.amazonaws.util.StringUtils;

public class CreatePlatformVersionRequestMarshaller
implements Marshaller<Request<CreatePlatformVersionRequest>, CreatePlatformVersionRequest> {
    @Override
    public Request<CreatePlatformVersionRequest> marshall(CreatePlatformVersionRequest createPlatformVersionRequest) {
        S3Location platformDefinitionBundle;
        if (createPlatformVersionRequest == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest<CreatePlatformVersionRequest> request = new DefaultRequest<CreatePlatformVersionRequest>(createPlatformVersionRequest, "AWSElasticBeanstalk");
        request.addParameter("Action", "CreatePlatformVersion");
        request.addParameter("Version", "2010-12-01");
        request.setHttpMethod(HttpMethodName.POST);
        if (createPlatformVersionRequest.getPlatformName() != null) {
            request.addParameter("PlatformName", StringUtils.fromString(createPlatformVersionRequest.getPlatformName()));
        }
        if (createPlatformVersionRequest.getPlatformVersion() != null) {
            request.addParameter("PlatformVersion", StringUtils.fromString(createPlatformVersionRequest.getPlatformVersion()));
        }
        if ((platformDefinitionBundle = createPlatformVersionRequest.getPlatformDefinitionBundle()) != null) {
            if (platformDefinitionBundle.getS3Bucket() != null) {
                request.addParameter("PlatformDefinitionBundle.S3Bucket", StringUtils.fromString(platformDefinitionBundle.getS3Bucket()));
            }
            if (platformDefinitionBundle.getS3Key() != null) {
                request.addParameter("PlatformDefinitionBundle.S3Key", StringUtils.fromString(platformDefinitionBundle.getS3Key()));
            }
        }
        if (createPlatformVersionRequest.getEnvironmentName() != null) {
            request.addParameter("EnvironmentName", StringUtils.fromString(createPlatformVersionRequest.getEnvironmentName()));
        }
        if (!createPlatformVersionRequest.getOptionSettings().isEmpty() || !((SdkInternalList)createPlatformVersionRequest.getOptionSettings()).isAutoConstruct()) {
            SdkInternalList optionSettingsList = (SdkInternalList)createPlatformVersionRequest.getOptionSettings();
            int optionSettingsListIndex = 1;
            for (ConfigurationOptionSetting optionSettingsListValue : optionSettingsList) {
                if (optionSettingsListValue.getResourceName() != null) {
                    request.addParameter("OptionSettings.member." + optionSettingsListIndex + ".ResourceName", StringUtils.fromString(optionSettingsListValue.getResourceName()));
                }
                if (optionSettingsListValue.getNamespace() != null) {
                    request.addParameter("OptionSettings.member." + optionSettingsListIndex + ".Namespace", StringUtils.fromString(optionSettingsListValue.getNamespace()));
                }
                if (optionSettingsListValue.getOptionName() != null) {
                    request.addParameter("OptionSettings.member." + optionSettingsListIndex + ".OptionName", StringUtils.fromString(optionSettingsListValue.getOptionName()));
                }
                if (optionSettingsListValue.getValue() != null) {
                    request.addParameter("OptionSettings.member." + optionSettingsListIndex + ".Value", StringUtils.fromString(optionSettingsListValue.getValue()));
                }
                ++optionSettingsListIndex;
            }
        }
        return request;
    }
}

