/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.elasticache.model.transform;

import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.SdkClientException;
import com.amazonaws.http.HttpMethodName;
import com.amazonaws.internal.SdkInternalList;
import com.amazonaws.services.elasticache.model.ParameterNameValue;
import com.amazonaws.services.elasticache.model.ResetCacheParameterGroupRequest;
import com.amazonaws.transform.Marshaller;
import com.amazonaws.util.StringUtils;

public class ResetCacheParameterGroupRequestMarshaller
implements Marshaller<Request<ResetCacheParameterGroupRequest>, ResetCacheParameterGroupRequest> {
    @Override
    public Request<ResetCacheParameterGroupRequest> marshall(ResetCacheParameterGroupRequest resetCacheParameterGroupRequest) {
        if (resetCacheParameterGroupRequest == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest<ResetCacheParameterGroupRequest> request = new DefaultRequest<ResetCacheParameterGroupRequest>(resetCacheParameterGroupRequest, "AmazonElastiCache");
        request.addParameter("Action", "ResetCacheParameterGroup");
        request.addParameter("Version", "2015-02-02");
        request.setHttpMethod(HttpMethodName.POST);
        if (resetCacheParameterGroupRequest.getCacheParameterGroupName() != null) {
            request.addParameter("CacheParameterGroupName", StringUtils.fromString(resetCacheParameterGroupRequest.getCacheParameterGroupName()));
        }
        if (resetCacheParameterGroupRequest.getResetAllParameters() != null) {
            request.addParameter("ResetAllParameters", StringUtils.fromBoolean(resetCacheParameterGroupRequest.getResetAllParameters()));
        }
        if (!resetCacheParameterGroupRequest.getParameterNameValues().isEmpty() || !((SdkInternalList)resetCacheParameterGroupRequest.getParameterNameValues()).isAutoConstruct()) {
            SdkInternalList parameterNameValuesList = (SdkInternalList)resetCacheParameterGroupRequest.getParameterNameValues();
            int parameterNameValuesListIndex = 1;
            for (ParameterNameValue parameterNameValuesListValue : parameterNameValuesList) {
                if (parameterNameValuesListValue.getParameterName() != null) {
                    request.addParameter("ParameterNameValues.ParameterNameValue." + parameterNameValuesListIndex + ".ParameterName", StringUtils.fromString(parameterNameValuesListValue.getParameterName()));
                }
                if (parameterNameValuesListValue.getParameterValue() != null) {
                    request.addParameter("ParameterNameValues.ParameterNameValue." + parameterNameValuesListIndex + ".ParameterValue", StringUtils.fromString(parameterNameValuesListValue.getParameterValue()));
                }
                ++parameterNameValuesListIndex;
            }
        }
        return request;
    }
}

