/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.elasticache.model.transform;

import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.SdkClientException;
import com.amazonaws.http.HttpMethodName;
import com.amazonaws.internal.SdkInternalList;
import com.amazonaws.services.elasticache.model.ModifyReplicationGroupShardConfigurationRequest;
import com.amazonaws.services.elasticache.model.ReshardingConfiguration;
import com.amazonaws.transform.Marshaller;
import com.amazonaws.util.StringUtils;

public class ModifyReplicationGroupShardConfigurationRequestMarshaller
implements Marshaller<Request<ModifyReplicationGroupShardConfigurationRequest>, ModifyReplicationGroupShardConfigurationRequest> {
    @Override
    public Request<ModifyReplicationGroupShardConfigurationRequest> marshall(ModifyReplicationGroupShardConfigurationRequest modifyReplicationGroupShardConfigurationRequest) {
        if (modifyReplicationGroupShardConfigurationRequest == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest<ModifyReplicationGroupShardConfigurationRequest> request = new DefaultRequest<ModifyReplicationGroupShardConfigurationRequest>(modifyReplicationGroupShardConfigurationRequest, "AmazonElastiCache");
        request.addParameter("Action", "ModifyReplicationGroupShardConfiguration");
        request.addParameter("Version", "2015-02-02");
        request.setHttpMethod(HttpMethodName.POST);
        if (modifyReplicationGroupShardConfigurationRequest.getReplicationGroupId() != null) {
            request.addParameter("ReplicationGroupId", StringUtils.fromString(modifyReplicationGroupShardConfigurationRequest.getReplicationGroupId()));
        }
        if (modifyReplicationGroupShardConfigurationRequest.getNodeGroupCount() != null) {
            request.addParameter("NodeGroupCount", StringUtils.fromInteger(modifyReplicationGroupShardConfigurationRequest.getNodeGroupCount()));
        }
        if (modifyReplicationGroupShardConfigurationRequest.getApplyImmediately() != null) {
            request.addParameter("ApplyImmediately", StringUtils.fromBoolean(modifyReplicationGroupShardConfigurationRequest.getApplyImmediately()));
        }
        if (!modifyReplicationGroupShardConfigurationRequest.getReshardingConfiguration().isEmpty() || !((SdkInternalList)modifyReplicationGroupShardConfigurationRequest.getReshardingConfiguration()).isAutoConstruct()) {
            SdkInternalList reshardingConfigurationList = (SdkInternalList)modifyReplicationGroupShardConfigurationRequest.getReshardingConfiguration();
            int reshardingConfigurationListIndex = 1;
            for (ReshardingConfiguration reshardingConfigurationListValue : reshardingConfigurationList) {
                if (!reshardingConfigurationListValue.getPreferredAvailabilityZones().isEmpty() || !((SdkInternalList)reshardingConfigurationListValue.getPreferredAvailabilityZones()).isAutoConstruct()) {
                    SdkInternalList preferredAvailabilityZonesList = (SdkInternalList)reshardingConfigurationListValue.getPreferredAvailabilityZones();
                    int preferredAvailabilityZonesListIndex = 1;
                    for (String preferredAvailabilityZonesListValue : preferredAvailabilityZonesList) {
                        if (preferredAvailabilityZonesListValue != null) {
                            request.addParameter("ReshardingConfiguration.ReshardingConfiguration." + reshardingConfigurationListIndex + ".PreferredAvailabilityZones.AvailabilityZone." + preferredAvailabilityZonesListIndex, StringUtils.fromString(preferredAvailabilityZonesListValue));
                        }
                        ++preferredAvailabilityZonesListIndex;
                    }
                }
                ++reshardingConfigurationListIndex;
            }
        }
        if (!modifyReplicationGroupShardConfigurationRequest.getNodeGroupsToRemove().isEmpty() || !((SdkInternalList)modifyReplicationGroupShardConfigurationRequest.getNodeGroupsToRemove()).isAutoConstruct()) {
            SdkInternalList nodeGroupsToRemoveList = (SdkInternalList)modifyReplicationGroupShardConfigurationRequest.getNodeGroupsToRemove();
            int nodeGroupsToRemoveListIndex = 1;
            for (String nodeGroupsToRemoveListValue : nodeGroupsToRemoveList) {
                if (nodeGroupsToRemoveListValue != null) {
                    request.addParameter("NodeGroupsToRemove.NodeGroupToRemove." + nodeGroupsToRemoveListIndex, StringUtils.fromString(nodeGroupsToRemoveListValue));
                }
                ++nodeGroupsToRemoveListIndex;
            }
        }
        return request;
    }
}

