/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.elasticache.model.transform;

import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.SdkClientException;
import com.amazonaws.http.HttpMethodName;
import com.amazonaws.internal.SdkInternalList;
import com.amazonaws.services.elasticache.model.ModifyCacheClusterRequest;
import com.amazonaws.transform.Marshaller;
import com.amazonaws.util.StringUtils;

public class ModifyCacheClusterRequestMarshaller
implements Marshaller<Request<ModifyCacheClusterRequest>, ModifyCacheClusterRequest> {
    @Override
    public Request<ModifyCacheClusterRequest> marshall(ModifyCacheClusterRequest modifyCacheClusterRequest) {
        if (modifyCacheClusterRequest == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest<ModifyCacheClusterRequest> request = new DefaultRequest<ModifyCacheClusterRequest>(modifyCacheClusterRequest, "AmazonElastiCache");
        request.addParameter("Action", "ModifyCacheCluster");
        request.addParameter("Version", "2015-02-02");
        request.setHttpMethod(HttpMethodName.POST);
        if (modifyCacheClusterRequest.getCacheClusterId() != null) {
            request.addParameter("CacheClusterId", StringUtils.fromString(modifyCacheClusterRequest.getCacheClusterId()));
        }
        if (modifyCacheClusterRequest.getNumCacheNodes() != null) {
            request.addParameter("NumCacheNodes", StringUtils.fromInteger(modifyCacheClusterRequest.getNumCacheNodes()));
        }
        if (!modifyCacheClusterRequest.getCacheNodeIdsToRemove().isEmpty() || !((SdkInternalList)modifyCacheClusterRequest.getCacheNodeIdsToRemove()).isAutoConstruct()) {
            SdkInternalList cacheNodeIdsToRemoveList = (SdkInternalList)modifyCacheClusterRequest.getCacheNodeIdsToRemove();
            int cacheNodeIdsToRemoveListIndex = 1;
            for (String cacheNodeIdsToRemoveListValue : cacheNodeIdsToRemoveList) {
                if (cacheNodeIdsToRemoveListValue != null) {
                    request.addParameter("CacheNodeIdsToRemove.CacheNodeId." + cacheNodeIdsToRemoveListIndex, StringUtils.fromString(cacheNodeIdsToRemoveListValue));
                }
                ++cacheNodeIdsToRemoveListIndex;
            }
        }
        if (modifyCacheClusterRequest.getAZMode() != null) {
            request.addParameter("AZMode", StringUtils.fromString(modifyCacheClusterRequest.getAZMode()));
        }
        if (!modifyCacheClusterRequest.getNewAvailabilityZones().isEmpty() || !((SdkInternalList)modifyCacheClusterRequest.getNewAvailabilityZones()).isAutoConstruct()) {
            SdkInternalList newAvailabilityZonesList = (SdkInternalList)modifyCacheClusterRequest.getNewAvailabilityZones();
            int newAvailabilityZonesListIndex = 1;
            for (String newAvailabilityZonesListValue : newAvailabilityZonesList) {
                if (newAvailabilityZonesListValue != null) {
                    request.addParameter("NewAvailabilityZones.PreferredAvailabilityZone." + newAvailabilityZonesListIndex, StringUtils.fromString(newAvailabilityZonesListValue));
                }
                ++newAvailabilityZonesListIndex;
            }
        }
        if (!modifyCacheClusterRequest.getCacheSecurityGroupNames().isEmpty() || !((SdkInternalList)modifyCacheClusterRequest.getCacheSecurityGroupNames()).isAutoConstruct()) {
            SdkInternalList cacheSecurityGroupNamesList = (SdkInternalList)modifyCacheClusterRequest.getCacheSecurityGroupNames();
            int cacheSecurityGroupNamesListIndex = 1;
            for (String cacheSecurityGroupNamesListValue : cacheSecurityGroupNamesList) {
                if (cacheSecurityGroupNamesListValue != null) {
                    request.addParameter("CacheSecurityGroupNames.CacheSecurityGroupName." + cacheSecurityGroupNamesListIndex, StringUtils.fromString(cacheSecurityGroupNamesListValue));
                }
                ++cacheSecurityGroupNamesListIndex;
            }
        }
        if (!modifyCacheClusterRequest.getSecurityGroupIds().isEmpty() || !((SdkInternalList)modifyCacheClusterRequest.getSecurityGroupIds()).isAutoConstruct()) {
            SdkInternalList securityGroupIdsList = (SdkInternalList)modifyCacheClusterRequest.getSecurityGroupIds();
            int securityGroupIdsListIndex = 1;
            for (String securityGroupIdsListValue : securityGroupIdsList) {
                if (securityGroupIdsListValue != null) {
                    request.addParameter("SecurityGroupIds.SecurityGroupId." + securityGroupIdsListIndex, StringUtils.fromString(securityGroupIdsListValue));
                }
                ++securityGroupIdsListIndex;
            }
        }
        if (modifyCacheClusterRequest.getPreferredMaintenanceWindow() != null) {
            request.addParameter("PreferredMaintenanceWindow", StringUtils.fromString(modifyCacheClusterRequest.getPreferredMaintenanceWindow()));
        }
        if (modifyCacheClusterRequest.getNotificationTopicArn() != null) {
            request.addParameter("NotificationTopicArn", StringUtils.fromString(modifyCacheClusterRequest.getNotificationTopicArn()));
        }
        if (modifyCacheClusterRequest.getCacheParameterGroupName() != null) {
            request.addParameter("CacheParameterGroupName", StringUtils.fromString(modifyCacheClusterRequest.getCacheParameterGroupName()));
        }
        if (modifyCacheClusterRequest.getNotificationTopicStatus() != null) {
            request.addParameter("NotificationTopicStatus", StringUtils.fromString(modifyCacheClusterRequest.getNotificationTopicStatus()));
        }
        if (modifyCacheClusterRequest.getApplyImmediately() != null) {
            request.addParameter("ApplyImmediately", StringUtils.fromBoolean(modifyCacheClusterRequest.getApplyImmediately()));
        }
        if (modifyCacheClusterRequest.getEngineVersion() != null) {
            request.addParameter("EngineVersion", StringUtils.fromString(modifyCacheClusterRequest.getEngineVersion()));
        }
        if (modifyCacheClusterRequest.getAutoMinorVersionUpgrade() != null) {
            request.addParameter("AutoMinorVersionUpgrade", StringUtils.fromBoolean(modifyCacheClusterRequest.getAutoMinorVersionUpgrade()));
        }
        if (modifyCacheClusterRequest.getSnapshotRetentionLimit() != null) {
            request.addParameter("SnapshotRetentionLimit", StringUtils.fromInteger(modifyCacheClusterRequest.getSnapshotRetentionLimit()));
        }
        if (modifyCacheClusterRequest.getSnapshotWindow() != null) {
            request.addParameter("SnapshotWindow", StringUtils.fromString(modifyCacheClusterRequest.getSnapshotWindow()));
        }
        if (modifyCacheClusterRequest.getCacheNodeType() != null) {
            request.addParameter("CacheNodeType", StringUtils.fromString(modifyCacheClusterRequest.getCacheNodeType()));
        }
        return request;
    }
}

