/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.ecs.model.transform;

import com.amazonaws.SdkClientException;
import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.MarshallLocation;
import com.amazonaws.protocol.MarshallingInfo;
import com.amazonaws.protocol.MarshallingType;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.services.ecs.model.Tmpfs;
import java.util.List;

@SdkInternalApi
public class TmpfsMarshaller {
    private static final MarshallingInfo<String> CONTAINERPATH_BINDING = MarshallingInfo.builder(MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("containerPath").build();
    private static final MarshallingInfo<Integer> SIZE_BINDING = MarshallingInfo.builder(MarshallingType.INTEGER).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("size").build();
    private static final MarshallingInfo<List> MOUNTOPTIONS_BINDING = MarshallingInfo.builder(MarshallingType.LIST).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("mountOptions").build();
    private static final TmpfsMarshaller instance = new TmpfsMarshaller();

    public static TmpfsMarshaller getInstance() {
        return instance;
    }

    public void marshall(Tmpfs tmpfs, ProtocolMarshaller protocolMarshaller) {
        if (tmpfs == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        try {
            protocolMarshaller.marshall(tmpfs.getContainerPath(), CONTAINERPATH_BINDING);
            protocolMarshaller.marshall(tmpfs.getSize(), SIZE_BINDING);
            protocolMarshaller.marshall(tmpfs.getMountOptions(), MOUNTOPTIONS_BINDING);
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), e);
        }
    }
}

