/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.ecs.model.transform;

import com.amazonaws.SdkClientException;
import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.MarshallLocation;
import com.amazonaws.protocol.MarshallingInfo;
import com.amazonaws.protocol.MarshallingType;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.services.ecs.model.HealthCheck;
import java.util.List;

@SdkInternalApi
public class HealthCheckMarshaller {
    private static final MarshallingInfo<List> COMMAND_BINDING = MarshallingInfo.builder(MarshallingType.LIST).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("command").build();
    private static final MarshallingInfo<Integer> INTERVAL_BINDING = MarshallingInfo.builder(MarshallingType.INTEGER).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("interval").build();
    private static final MarshallingInfo<Integer> TIMEOUT_BINDING = MarshallingInfo.builder(MarshallingType.INTEGER).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("timeout").build();
    private static final MarshallingInfo<Integer> RETRIES_BINDING = MarshallingInfo.builder(MarshallingType.INTEGER).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("retries").build();
    private static final MarshallingInfo<Integer> STARTPERIOD_BINDING = MarshallingInfo.builder(MarshallingType.INTEGER).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("startPeriod").build();
    private static final HealthCheckMarshaller instance = new HealthCheckMarshaller();

    public static HealthCheckMarshaller getInstance() {
        return instance;
    }

    public void marshall(HealthCheck healthCheck, ProtocolMarshaller protocolMarshaller) {
        if (healthCheck == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        try {
            protocolMarshaller.marshall(healthCheck.getCommand(), COMMAND_BINDING);
            protocolMarshaller.marshall(healthCheck.getInterval(), INTERVAL_BINDING);
            protocolMarshaller.marshall(healthCheck.getTimeout(), TIMEOUT_BINDING);
            protocolMarshaller.marshall(healthCheck.getRetries(), RETRIES_BINDING);
            protocolMarshaller.marshall(healthCheck.getStartPeriod(), STARTPERIOD_BINDING);
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), e);
        }
    }
}

