/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.devicefarm.model;

import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.protocol.StructuredPojo;
import com.amazonaws.services.devicefarm.model.transform.InstanceProfileMarshaller;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class InstanceProfile
implements Serializable,
Cloneable,
StructuredPojo {
    private String arn;
    private Boolean packageCleanup;
    private List<String> excludeAppPackagesFromCleanup;
    private Boolean rebootAfterUse;
    private String name;
    private String description;

    public void setArn(String arn) {
        this.arn = arn;
    }

    public String getArn() {
        return this.arn;
    }

    public InstanceProfile withArn(String arn) {
        this.setArn(arn);
        return this;
    }

    public void setPackageCleanup(Boolean packageCleanup) {
        this.packageCleanup = packageCleanup;
    }

    public Boolean getPackageCleanup() {
        return this.packageCleanup;
    }

    public InstanceProfile withPackageCleanup(Boolean packageCleanup) {
        this.setPackageCleanup(packageCleanup);
        return this;
    }

    public Boolean isPackageCleanup() {
        return this.packageCleanup;
    }

    public List<String> getExcludeAppPackagesFromCleanup() {
        return this.excludeAppPackagesFromCleanup;
    }

    public void setExcludeAppPackagesFromCleanup(Collection<String> excludeAppPackagesFromCleanup) {
        if (excludeAppPackagesFromCleanup == null) {
            this.excludeAppPackagesFromCleanup = null;
            return;
        }
        this.excludeAppPackagesFromCleanup = new ArrayList<String>(excludeAppPackagesFromCleanup);
    }

    public InstanceProfile withExcludeAppPackagesFromCleanup(String ... excludeAppPackagesFromCleanup) {
        if (this.excludeAppPackagesFromCleanup == null) {
            this.setExcludeAppPackagesFromCleanup(new ArrayList<String>(excludeAppPackagesFromCleanup.length));
        }
        for (String ele : excludeAppPackagesFromCleanup) {
            this.excludeAppPackagesFromCleanup.add(ele);
        }
        return this;
    }

    public InstanceProfile withExcludeAppPackagesFromCleanup(Collection<String> excludeAppPackagesFromCleanup) {
        this.setExcludeAppPackagesFromCleanup(excludeAppPackagesFromCleanup);
        return this;
    }

    public void setRebootAfterUse(Boolean rebootAfterUse) {
        this.rebootAfterUse = rebootAfterUse;
    }

    public Boolean getRebootAfterUse() {
        return this.rebootAfterUse;
    }

    public InstanceProfile withRebootAfterUse(Boolean rebootAfterUse) {
        this.setRebootAfterUse(rebootAfterUse);
        return this;
    }

    public Boolean isRebootAfterUse() {
        return this.rebootAfterUse;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getName() {
        return this.name;
    }

    public InstanceProfile withName(String name) {
        this.setName(name);
        return this;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public String getDescription() {
        return this.description;
    }

    public InstanceProfile withDescription(String description) {
        this.setDescription(description);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getArn() != null) {
            sb.append("Arn: ").append(this.getArn()).append(",");
        }
        if (this.getPackageCleanup() != null) {
            sb.append("PackageCleanup: ").append(this.getPackageCleanup()).append(",");
        }
        if (this.getExcludeAppPackagesFromCleanup() != null) {
            sb.append("ExcludeAppPackagesFromCleanup: ").append(this.getExcludeAppPackagesFromCleanup()).append(",");
        }
        if (this.getRebootAfterUse() != null) {
            sb.append("RebootAfterUse: ").append(this.getRebootAfterUse()).append(",");
        }
        if (this.getName() != null) {
            sb.append("Name: ").append(this.getName()).append(",");
        }
        if (this.getDescription() != null) {
            sb.append("Description: ").append(this.getDescription());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof InstanceProfile)) {
            return false;
        }
        InstanceProfile other = (InstanceProfile)obj;
        if (other.getArn() == null ^ this.getArn() == null) {
            return false;
        }
        if (other.getArn() != null && !other.getArn().equals(this.getArn())) {
            return false;
        }
        if (other.getPackageCleanup() == null ^ this.getPackageCleanup() == null) {
            return false;
        }
        if (other.getPackageCleanup() != null && !other.getPackageCleanup().equals(this.getPackageCleanup())) {
            return false;
        }
        if (other.getExcludeAppPackagesFromCleanup() == null ^ this.getExcludeAppPackagesFromCleanup() == null) {
            return false;
        }
        if (other.getExcludeAppPackagesFromCleanup() != null && !other.getExcludeAppPackagesFromCleanup().equals(this.getExcludeAppPackagesFromCleanup())) {
            return false;
        }
        if (other.getRebootAfterUse() == null ^ this.getRebootAfterUse() == null) {
            return false;
        }
        if (other.getRebootAfterUse() != null && !other.getRebootAfterUse().equals(this.getRebootAfterUse())) {
            return false;
        }
        if (other.getName() == null ^ this.getName() == null) {
            return false;
        }
        if (other.getName() != null && !other.getName().equals(this.getName())) {
            return false;
        }
        if (other.getDescription() == null ^ this.getDescription() == null) {
            return false;
        }
        return other.getDescription() == null || other.getDescription().equals(this.getDescription());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getArn() == null ? 0 : this.getArn().hashCode());
        hashCode = 31 * hashCode + (this.getPackageCleanup() == null ? 0 : this.getPackageCleanup().hashCode());
        hashCode = 31 * hashCode + (this.getExcludeAppPackagesFromCleanup() == null ? 0 : this.getExcludeAppPackagesFromCleanup().hashCode());
        hashCode = 31 * hashCode + (this.getRebootAfterUse() == null ? 0 : this.getRebootAfterUse().hashCode());
        hashCode = 31 * hashCode + (this.getName() == null ? 0 : this.getName().hashCode());
        hashCode = 31 * hashCode + (this.getDescription() == null ? 0 : this.getDescription().hashCode());
        return hashCode;
    }

    public InstanceProfile clone() {
        try {
            return (InstanceProfile)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }

    @Override
    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        InstanceProfileMarshaller.getInstance().marshall(this, protocolMarshaller);
    }
}

