/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.devicefarm.model;

import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.protocol.StructuredPojo;
import com.amazonaws.services.devicefarm.model.InstanceProfile;
import com.amazonaws.services.devicefarm.model.InstanceStatus;
import com.amazonaws.services.devicefarm.model.transform.DeviceInstanceMarshaller;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class DeviceInstance
implements Serializable,
Cloneable,
StructuredPojo {
    private String arn;
    private String deviceArn;
    private List<String> labels;
    private String status;
    private String udid;
    private InstanceProfile instanceProfile;

    public void setArn(String arn) {
        this.arn = arn;
    }

    public String getArn() {
        return this.arn;
    }

    public DeviceInstance withArn(String arn) {
        this.setArn(arn);
        return this;
    }

    public void setDeviceArn(String deviceArn) {
        this.deviceArn = deviceArn;
    }

    public String getDeviceArn() {
        return this.deviceArn;
    }

    public DeviceInstance withDeviceArn(String deviceArn) {
        this.setDeviceArn(deviceArn);
        return this;
    }

    public List<String> getLabels() {
        return this.labels;
    }

    public void setLabels(Collection<String> labels) {
        if (labels == null) {
            this.labels = null;
            return;
        }
        this.labels = new ArrayList<String>(labels);
    }

    public DeviceInstance withLabels(String ... labels) {
        if (this.labels == null) {
            this.setLabels(new ArrayList<String>(labels.length));
        }
        for (String ele : labels) {
            this.labels.add(ele);
        }
        return this;
    }

    public DeviceInstance withLabels(Collection<String> labels) {
        this.setLabels(labels);
        return this;
    }

    public void setStatus(String status) {
        this.status = status;
    }

    public String getStatus() {
        return this.status;
    }

    public DeviceInstance withStatus(String status) {
        this.setStatus(status);
        return this;
    }

    public DeviceInstance withStatus(InstanceStatus status) {
        this.status = status.toString();
        return this;
    }

    public void setUdid(String udid) {
        this.udid = udid;
    }

    public String getUdid() {
        return this.udid;
    }

    public DeviceInstance withUdid(String udid) {
        this.setUdid(udid);
        return this;
    }

    public void setInstanceProfile(InstanceProfile instanceProfile) {
        this.instanceProfile = instanceProfile;
    }

    public InstanceProfile getInstanceProfile() {
        return this.instanceProfile;
    }

    public DeviceInstance withInstanceProfile(InstanceProfile instanceProfile) {
        this.setInstanceProfile(instanceProfile);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getArn() != null) {
            sb.append("Arn: ").append(this.getArn()).append(",");
        }
        if (this.getDeviceArn() != null) {
            sb.append("DeviceArn: ").append(this.getDeviceArn()).append(",");
        }
        if (this.getLabels() != null) {
            sb.append("Labels: ").append(this.getLabels()).append(",");
        }
        if (this.getStatus() != null) {
            sb.append("Status: ").append(this.getStatus()).append(",");
        }
        if (this.getUdid() != null) {
            sb.append("Udid: ").append(this.getUdid()).append(",");
        }
        if (this.getInstanceProfile() != null) {
            sb.append("InstanceProfile: ").append(this.getInstanceProfile());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DeviceInstance)) {
            return false;
        }
        DeviceInstance other = (DeviceInstance)obj;
        if (other.getArn() == null ^ this.getArn() == null) {
            return false;
        }
        if (other.getArn() != null && !other.getArn().equals(this.getArn())) {
            return false;
        }
        if (other.getDeviceArn() == null ^ this.getDeviceArn() == null) {
            return false;
        }
        if (other.getDeviceArn() != null && !other.getDeviceArn().equals(this.getDeviceArn())) {
            return false;
        }
        if (other.getLabels() == null ^ this.getLabels() == null) {
            return false;
        }
        if (other.getLabels() != null && !other.getLabels().equals(this.getLabels())) {
            return false;
        }
        if (other.getStatus() == null ^ this.getStatus() == null) {
            return false;
        }
        if (other.getStatus() != null && !other.getStatus().equals(this.getStatus())) {
            return false;
        }
        if (other.getUdid() == null ^ this.getUdid() == null) {
            return false;
        }
        if (other.getUdid() != null && !other.getUdid().equals(this.getUdid())) {
            return false;
        }
        if (other.getInstanceProfile() == null ^ this.getInstanceProfile() == null) {
            return false;
        }
        return other.getInstanceProfile() == null || other.getInstanceProfile().equals(this.getInstanceProfile());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getArn() == null ? 0 : this.getArn().hashCode());
        hashCode = 31 * hashCode + (this.getDeviceArn() == null ? 0 : this.getDeviceArn().hashCode());
        hashCode = 31 * hashCode + (this.getLabels() == null ? 0 : this.getLabels().hashCode());
        hashCode = 31 * hashCode + (this.getStatus() == null ? 0 : this.getStatus().hashCode());
        hashCode = 31 * hashCode + (this.getUdid() == null ? 0 : this.getUdid().hashCode());
        hashCode = 31 * hashCode + (this.getInstanceProfile() == null ? 0 : this.getInstanceProfile().hashCode());
        return hashCode;
    }

    public DeviceInstance clone() {
        try {
            return (DeviceInstance)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }

    @Override
    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        DeviceInstanceMarshaller.getInstance().marshall(this, protocolMarshaller);
    }
}

