/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.costexplorer.model.transform;

import com.amazonaws.SdkClientException;
import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.MarshallLocation;
import com.amazonaws.protocol.MarshallingInfo;
import com.amazonaws.protocol.MarshallingType;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.services.costexplorer.model.EC2Specification;

@SdkInternalApi
public class EC2SpecificationMarshaller {
    private static final MarshallingInfo<String> OFFERINGCLASS_BINDING = MarshallingInfo.builder(MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("OfferingClass").build();
    private static final EC2SpecificationMarshaller instance = new EC2SpecificationMarshaller();

    public static EC2SpecificationMarshaller getInstance() {
        return instance;
    }

    public void marshall(EC2Specification eC2Specification, ProtocolMarshaller protocolMarshaller) {
        if (eC2Specification == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        try {
            protocolMarshaller.marshall(eC2Specification.getOfferingClass(), OFFERINGCLASS_BINDING);
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), e);
        }
    }
}

