/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.costexplorer.model;

import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.services.costexplorer.model.DateInterval;
import com.amazonaws.services.costexplorer.model.Expression;
import com.amazonaws.services.costexplorer.model.Granularity;
import com.amazonaws.services.costexplorer.model.GroupDefinition;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class GetReservationCoverageRequest
extends AmazonWebServiceRequest
implements Serializable,
Cloneable {
    private DateInterval timePeriod;
    private List<GroupDefinition> groupBy;
    private String granularity;
    private Expression filter;
    private String nextPageToken;

    public void setTimePeriod(DateInterval timePeriod) {
        this.timePeriod = timePeriod;
    }

    public DateInterval getTimePeriod() {
        return this.timePeriod;
    }

    public GetReservationCoverageRequest withTimePeriod(DateInterval timePeriod) {
        this.setTimePeriod(timePeriod);
        return this;
    }

    public List<GroupDefinition> getGroupBy() {
        return this.groupBy;
    }

    public void setGroupBy(Collection<GroupDefinition> groupBy) {
        if (groupBy == null) {
            this.groupBy = null;
            return;
        }
        this.groupBy = new ArrayList<GroupDefinition>(groupBy);
    }

    public GetReservationCoverageRequest withGroupBy(GroupDefinition ... groupBy) {
        if (this.groupBy == null) {
            this.setGroupBy(new ArrayList<GroupDefinition>(groupBy.length));
        }
        for (GroupDefinition ele : groupBy) {
            this.groupBy.add(ele);
        }
        return this;
    }

    public GetReservationCoverageRequest withGroupBy(Collection<GroupDefinition> groupBy) {
        this.setGroupBy(groupBy);
        return this;
    }

    public void setGranularity(String granularity) {
        this.granularity = granularity;
    }

    public String getGranularity() {
        return this.granularity;
    }

    public GetReservationCoverageRequest withGranularity(String granularity) {
        this.setGranularity(granularity);
        return this;
    }

    public GetReservationCoverageRequest withGranularity(Granularity granularity) {
        this.granularity = granularity.toString();
        return this;
    }

    public void setFilter(Expression filter) {
        this.filter = filter;
    }

    public Expression getFilter() {
        return this.filter;
    }

    public GetReservationCoverageRequest withFilter(Expression filter) {
        this.setFilter(filter);
        return this;
    }

    public void setNextPageToken(String nextPageToken) {
        this.nextPageToken = nextPageToken;
    }

    public String getNextPageToken() {
        return this.nextPageToken;
    }

    public GetReservationCoverageRequest withNextPageToken(String nextPageToken) {
        this.setNextPageToken(nextPageToken);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getTimePeriod() != null) {
            sb.append("TimePeriod: ").append(this.getTimePeriod()).append(",");
        }
        if (this.getGroupBy() != null) {
            sb.append("GroupBy: ").append(this.getGroupBy()).append(",");
        }
        if (this.getGranularity() != null) {
            sb.append("Granularity: ").append(this.getGranularity()).append(",");
        }
        if (this.getFilter() != null) {
            sb.append("Filter: ").append(this.getFilter()).append(",");
        }
        if (this.getNextPageToken() != null) {
            sb.append("NextPageToken: ").append(this.getNextPageToken());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetReservationCoverageRequest)) {
            return false;
        }
        GetReservationCoverageRequest other = (GetReservationCoverageRequest)obj;
        if (other.getTimePeriod() == null ^ this.getTimePeriod() == null) {
            return false;
        }
        if (other.getTimePeriod() != null && !other.getTimePeriod().equals(this.getTimePeriod())) {
            return false;
        }
        if (other.getGroupBy() == null ^ this.getGroupBy() == null) {
            return false;
        }
        if (other.getGroupBy() != null && !other.getGroupBy().equals(this.getGroupBy())) {
            return false;
        }
        if (other.getGranularity() == null ^ this.getGranularity() == null) {
            return false;
        }
        if (other.getGranularity() != null && !other.getGranularity().equals(this.getGranularity())) {
            return false;
        }
        if (other.getFilter() == null ^ this.getFilter() == null) {
            return false;
        }
        if (other.getFilter() != null && !other.getFilter().equals(this.getFilter())) {
            return false;
        }
        if (other.getNextPageToken() == null ^ this.getNextPageToken() == null) {
            return false;
        }
        return other.getNextPageToken() == null || other.getNextPageToken().equals(this.getNextPageToken());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getTimePeriod() == null ? 0 : this.getTimePeriod().hashCode());
        hashCode = 31 * hashCode + (this.getGroupBy() == null ? 0 : this.getGroupBy().hashCode());
        hashCode = 31 * hashCode + (this.getGranularity() == null ? 0 : this.getGranularity().hashCode());
        hashCode = 31 * hashCode + (this.getFilter() == null ? 0 : this.getFilter().hashCode());
        hashCode = 31 * hashCode + (this.getNextPageToken() == null ? 0 : this.getNextPageToken().hashCode());
        return hashCode;
    }

    @Override
    public GetReservationCoverageRequest clone() {
        return (GetReservationCoverageRequest)super.clone();
    }
}

