/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.connect;

import com.amazonaws.annotation.ThreadSafe;
import com.amazonaws.client.AwsAsyncClientParams;
import com.amazonaws.handlers.AsyncHandler;
import com.amazonaws.services.connect.AmazonConnectAsync;
import com.amazonaws.services.connect.AmazonConnectAsyncClientBuilder;
import com.amazonaws.services.connect.AmazonConnectClient;
import com.amazonaws.services.connect.model.StartOutboundVoiceContactRequest;
import com.amazonaws.services.connect.model.StartOutboundVoiceContactResult;
import com.amazonaws.services.connect.model.StopContactRequest;
import com.amazonaws.services.connect.model.StopContactResult;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;

@ThreadSafe
public class AmazonConnectAsyncClient
extends AmazonConnectClient
implements AmazonConnectAsync {
    private static final int DEFAULT_THREAD_POOL_SIZE = 50;
    private final ExecutorService executorService;

    public static AmazonConnectAsyncClientBuilder asyncBuilder() {
        return AmazonConnectAsyncClientBuilder.standard();
    }

    AmazonConnectAsyncClient(AwsAsyncClientParams asyncClientParams) {
        super(asyncClientParams);
        this.executorService = asyncClientParams.getExecutor();
    }

    public ExecutorService getExecutorService() {
        return this.executorService;
    }

    @Override
    public Future<StartOutboundVoiceContactResult> startOutboundVoiceContactAsync(StartOutboundVoiceContactRequest request) {
        return this.startOutboundVoiceContactAsync(request, null);
    }

    @Override
    public Future<StartOutboundVoiceContactResult> startOutboundVoiceContactAsync(StartOutboundVoiceContactRequest request, final AsyncHandler<StartOutboundVoiceContactRequest, StartOutboundVoiceContactResult> asyncHandler) {
        final StartOutboundVoiceContactRequest finalRequest = this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<StartOutboundVoiceContactResult>(){

            @Override
            public StartOutboundVoiceContactResult call() throws Exception {
                StartOutboundVoiceContactResult result = null;
                try {
                    result = AmazonConnectAsyncClient.this.executeStartOutboundVoiceContact(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess(finalRequest, result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<StopContactResult> stopContactAsync(StopContactRequest request) {
        return this.stopContactAsync(request, null);
    }

    @Override
    public Future<StopContactResult> stopContactAsync(StopContactRequest request, final AsyncHandler<StopContactRequest, StopContactResult> asyncHandler) {
        final StopContactRequest finalRequest = this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<StopContactResult>(){

            @Override
            public StopContactResult call() throws Exception {
                StopContactResult result = null;
                try {
                    result = AmazonConnectAsyncClient.this.executeStopContact(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess(finalRequest, result);
                }
                return result;
            }
        });
    }

    @Override
    public void shutdown() {
        super.shutdown();
        this.executorService.shutdownNow();
    }
}

