/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.config.model.transform;

import com.amazonaws.SdkClientException;
import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.MarshallLocation;
import com.amazonaws.protocol.MarshallingInfo;
import com.amazonaws.protocol.MarshallingType;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.services.config.model.BaseConfigurationItem;
import java.util.Date;
import java.util.Map;

@SdkInternalApi
public class BaseConfigurationItemMarshaller {
    private static final MarshallingInfo<String> VERSION_BINDING = MarshallingInfo.builder(MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("version").build();
    private static final MarshallingInfo<String> ACCOUNTID_BINDING = MarshallingInfo.builder(MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("accountId").build();
    private static final MarshallingInfo<Date> CONFIGURATIONITEMCAPTURETIME_BINDING = MarshallingInfo.builder(MarshallingType.DATE).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("configurationItemCaptureTime").build();
    private static final MarshallingInfo<String> CONFIGURATIONITEMSTATUS_BINDING = MarshallingInfo.builder(MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("configurationItemStatus").build();
    private static final MarshallingInfo<String> CONFIGURATIONSTATEID_BINDING = MarshallingInfo.builder(MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("configurationStateId").build();
    private static final MarshallingInfo<String> ARN_BINDING = MarshallingInfo.builder(MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("arn").build();
    private static final MarshallingInfo<String> RESOURCETYPE_BINDING = MarshallingInfo.builder(MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("resourceType").build();
    private static final MarshallingInfo<String> RESOURCEID_BINDING = MarshallingInfo.builder(MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("resourceId").build();
    private static final MarshallingInfo<String> RESOURCENAME_BINDING = MarshallingInfo.builder(MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("resourceName").build();
    private static final MarshallingInfo<String> AWSREGION_BINDING = MarshallingInfo.builder(MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("awsRegion").build();
    private static final MarshallingInfo<String> AVAILABILITYZONE_BINDING = MarshallingInfo.builder(MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("availabilityZone").build();
    private static final MarshallingInfo<Date> RESOURCECREATIONTIME_BINDING = MarshallingInfo.builder(MarshallingType.DATE).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("resourceCreationTime").build();
    private static final MarshallingInfo<String> CONFIGURATION_BINDING = MarshallingInfo.builder(MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("configuration").build();
    private static final MarshallingInfo<Map> SUPPLEMENTARYCONFIGURATION_BINDING = MarshallingInfo.builder(MarshallingType.MAP).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("supplementaryConfiguration").build();
    private static final BaseConfigurationItemMarshaller instance = new BaseConfigurationItemMarshaller();

    public static BaseConfigurationItemMarshaller getInstance() {
        return instance;
    }

    public void marshall(BaseConfigurationItem baseConfigurationItem, ProtocolMarshaller protocolMarshaller) {
        if (baseConfigurationItem == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        try {
            protocolMarshaller.marshall(baseConfigurationItem.getVersion(), VERSION_BINDING);
            protocolMarshaller.marshall(baseConfigurationItem.getAccountId(), ACCOUNTID_BINDING);
            protocolMarshaller.marshall(baseConfigurationItem.getConfigurationItemCaptureTime(), CONFIGURATIONITEMCAPTURETIME_BINDING);
            protocolMarshaller.marshall(baseConfigurationItem.getConfigurationItemStatus(), CONFIGURATIONITEMSTATUS_BINDING);
            protocolMarshaller.marshall(baseConfigurationItem.getConfigurationStateId(), CONFIGURATIONSTATEID_BINDING);
            protocolMarshaller.marshall(baseConfigurationItem.getArn(), ARN_BINDING);
            protocolMarshaller.marshall(baseConfigurationItem.getResourceType(), RESOURCETYPE_BINDING);
            protocolMarshaller.marshall(baseConfigurationItem.getResourceId(), RESOURCEID_BINDING);
            protocolMarshaller.marshall(baseConfigurationItem.getResourceName(), RESOURCENAME_BINDING);
            protocolMarshaller.marshall(baseConfigurationItem.getAwsRegion(), AWSREGION_BINDING);
            protocolMarshaller.marshall(baseConfigurationItem.getAvailabilityZone(), AVAILABILITYZONE_BINDING);
            protocolMarshaller.marshall(baseConfigurationItem.getResourceCreationTime(), RESOURCECREATIONTIME_BINDING);
            protocolMarshaller.marshall(baseConfigurationItem.getConfiguration(), CONFIGURATION_BINDING);
            protocolMarshaller.marshall(baseConfigurationItem.getSupplementaryConfiguration(), SUPPLEMENTARYCONFIGURATION_BINDING);
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), e);
        }
    }
}

