/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.config.model;

import com.amazonaws.AmazonWebServiceResult;
import com.amazonaws.ResponseMetadata;
import com.amazonaws.internal.SdkInternalList;
import com.amazonaws.services.config.model.BaseConfigurationItem;
import com.amazonaws.services.config.model.ResourceKey;
import java.io.Serializable;
import java.util.Collection;
import java.util.List;

public class BatchGetResourceConfigResult
extends AmazonWebServiceResult<ResponseMetadata>
implements Serializable,
Cloneable {
    private SdkInternalList<BaseConfigurationItem> baseConfigurationItems;
    private SdkInternalList<ResourceKey> unprocessedResourceKeys;

    public List<BaseConfigurationItem> getBaseConfigurationItems() {
        if (this.baseConfigurationItems == null) {
            this.baseConfigurationItems = new SdkInternalList();
        }
        return this.baseConfigurationItems;
    }

    public void setBaseConfigurationItems(Collection<BaseConfigurationItem> baseConfigurationItems) {
        if (baseConfigurationItems == null) {
            this.baseConfigurationItems = null;
            return;
        }
        this.baseConfigurationItems = new SdkInternalList<BaseConfigurationItem>(baseConfigurationItems);
    }

    public BatchGetResourceConfigResult withBaseConfigurationItems(BaseConfigurationItem ... baseConfigurationItems) {
        if (this.baseConfigurationItems == null) {
            this.setBaseConfigurationItems(new SdkInternalList<BaseConfigurationItem>(baseConfigurationItems.length));
        }
        for (BaseConfigurationItem ele : baseConfigurationItems) {
            this.baseConfigurationItems.add(ele);
        }
        return this;
    }

    public BatchGetResourceConfigResult withBaseConfigurationItems(Collection<BaseConfigurationItem> baseConfigurationItems) {
        this.setBaseConfigurationItems(baseConfigurationItems);
        return this;
    }

    public List<ResourceKey> getUnprocessedResourceKeys() {
        if (this.unprocessedResourceKeys == null) {
            this.unprocessedResourceKeys = new SdkInternalList();
        }
        return this.unprocessedResourceKeys;
    }

    public void setUnprocessedResourceKeys(Collection<ResourceKey> unprocessedResourceKeys) {
        if (unprocessedResourceKeys == null) {
            this.unprocessedResourceKeys = null;
            return;
        }
        this.unprocessedResourceKeys = new SdkInternalList<ResourceKey>(unprocessedResourceKeys);
    }

    public BatchGetResourceConfigResult withUnprocessedResourceKeys(ResourceKey ... unprocessedResourceKeys) {
        if (this.unprocessedResourceKeys == null) {
            this.setUnprocessedResourceKeys(new SdkInternalList<ResourceKey>(unprocessedResourceKeys.length));
        }
        for (ResourceKey ele : unprocessedResourceKeys) {
            this.unprocessedResourceKeys.add(ele);
        }
        return this;
    }

    public BatchGetResourceConfigResult withUnprocessedResourceKeys(Collection<ResourceKey> unprocessedResourceKeys) {
        this.setUnprocessedResourceKeys(unprocessedResourceKeys);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getBaseConfigurationItems() != null) {
            sb.append("BaseConfigurationItems: ").append(this.getBaseConfigurationItems()).append(",");
        }
        if (this.getUnprocessedResourceKeys() != null) {
            sb.append("UnprocessedResourceKeys: ").append(this.getUnprocessedResourceKeys());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof BatchGetResourceConfigResult)) {
            return false;
        }
        BatchGetResourceConfigResult other = (BatchGetResourceConfigResult)obj;
        if (other.getBaseConfigurationItems() == null ^ this.getBaseConfigurationItems() == null) {
            return false;
        }
        if (other.getBaseConfigurationItems() != null && !other.getBaseConfigurationItems().equals(this.getBaseConfigurationItems())) {
            return false;
        }
        if (other.getUnprocessedResourceKeys() == null ^ this.getUnprocessedResourceKeys() == null) {
            return false;
        }
        return other.getUnprocessedResourceKeys() == null || other.getUnprocessedResourceKeys().equals(this.getUnprocessedResourceKeys());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getBaseConfigurationItems() == null ? 0 : this.getBaseConfigurationItems().hashCode());
        hashCode = 31 * hashCode + (this.getUnprocessedResourceKeys() == null ? 0 : this.getUnprocessedResourceKeys().hashCode());
        return hashCode;
    }

    public BatchGetResourceConfigResult clone() {
        try {
            return (BatchGetResourceConfigResult)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }
}

