/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.config.model;

import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.internal.SdkInternalList;
import com.amazonaws.services.config.model.ResourceKey;
import java.io.Serializable;
import java.util.Collection;
import java.util.List;

public class BatchGetResourceConfigRequest
extends AmazonWebServiceRequest
implements Serializable,
Cloneable {
    private SdkInternalList<ResourceKey> resourceKeys;

    public List<ResourceKey> getResourceKeys() {
        if (this.resourceKeys == null) {
            this.resourceKeys = new SdkInternalList();
        }
        return this.resourceKeys;
    }

    public void setResourceKeys(Collection<ResourceKey> resourceKeys) {
        if (resourceKeys == null) {
            this.resourceKeys = null;
            return;
        }
        this.resourceKeys = new SdkInternalList<ResourceKey>(resourceKeys);
    }

    public BatchGetResourceConfigRequest withResourceKeys(ResourceKey ... resourceKeys) {
        if (this.resourceKeys == null) {
            this.setResourceKeys(new SdkInternalList<ResourceKey>(resourceKeys.length));
        }
        for (ResourceKey ele : resourceKeys) {
            this.resourceKeys.add(ele);
        }
        return this;
    }

    public BatchGetResourceConfigRequest withResourceKeys(Collection<ResourceKey> resourceKeys) {
        this.setResourceKeys(resourceKeys);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getResourceKeys() != null) {
            sb.append("ResourceKeys: ").append(this.getResourceKeys());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof BatchGetResourceConfigRequest)) {
            return false;
        }
        BatchGetResourceConfigRequest other = (BatchGetResourceConfigRequest)obj;
        if (other.getResourceKeys() == null ^ this.getResourceKeys() == null) {
            return false;
        }
        return other.getResourceKeys() == null || other.getResourceKeys().equals(this.getResourceKeys());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getResourceKeys() == null ? 0 : this.getResourceKeys().hashCode());
        return hashCode;
    }

    @Override
    public BatchGetResourceConfigRequest clone() {
        return (BatchGetResourceConfigRequest)super.clone();
    }
}

