/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.cloudsearchv2.model.transform;

import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.SdkClientException;
import com.amazonaws.http.HttpMethodName;
import com.amazonaws.internal.SdkInternalList;
import com.amazonaws.services.cloudsearchv2.model.DescribeIndexFieldsRequest;
import com.amazonaws.transform.Marshaller;
import com.amazonaws.util.StringUtils;

public class DescribeIndexFieldsRequestMarshaller
implements Marshaller<Request<DescribeIndexFieldsRequest>, DescribeIndexFieldsRequest> {
    @Override
    public Request<DescribeIndexFieldsRequest> marshall(DescribeIndexFieldsRequest describeIndexFieldsRequest) {
        if (describeIndexFieldsRequest == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest<DescribeIndexFieldsRequest> request = new DefaultRequest<DescribeIndexFieldsRequest>(describeIndexFieldsRequest, "AmazonCloudSearchv2");
        request.addParameter("Action", "DescribeIndexFields");
        request.addParameter("Version", "2013-01-01");
        request.setHttpMethod(HttpMethodName.POST);
        if (describeIndexFieldsRequest.getDomainName() != null) {
            request.addParameter("DomainName", StringUtils.fromString(describeIndexFieldsRequest.getDomainName()));
        }
        if (!describeIndexFieldsRequest.getFieldNames().isEmpty() || !((SdkInternalList)describeIndexFieldsRequest.getFieldNames()).isAutoConstruct()) {
            SdkInternalList fieldNamesList = (SdkInternalList)describeIndexFieldsRequest.getFieldNames();
            int fieldNamesListIndex = 1;
            for (String fieldNamesListValue : fieldNamesList) {
                if (fieldNamesListValue != null) {
                    request.addParameter("FieldNames.member." + fieldNamesListIndex, StringUtils.fromString(fieldNamesListValue));
                }
                ++fieldNamesListIndex;
            }
        }
        if (describeIndexFieldsRequest.getDeployed() != null) {
            request.addParameter("Deployed", StringUtils.fromBoolean(describeIndexFieldsRequest.getDeployed()));
        }
        return request;
    }
}

