/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.cloudsearchv2.model.transform;

import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.SdkClientException;
import com.amazonaws.http.HttpMethodName;
import com.amazonaws.internal.SdkInternalList;
import com.amazonaws.services.cloudsearchv2.model.DescribeAnalysisSchemesRequest;
import com.amazonaws.transform.Marshaller;
import com.amazonaws.util.StringUtils;

public class DescribeAnalysisSchemesRequestMarshaller
implements Marshaller<Request<DescribeAnalysisSchemesRequest>, DescribeAnalysisSchemesRequest> {
    @Override
    public Request<DescribeAnalysisSchemesRequest> marshall(DescribeAnalysisSchemesRequest describeAnalysisSchemesRequest) {
        if (describeAnalysisSchemesRequest == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest<DescribeAnalysisSchemesRequest> request = new DefaultRequest<DescribeAnalysisSchemesRequest>(describeAnalysisSchemesRequest, "AmazonCloudSearchv2");
        request.addParameter("Action", "DescribeAnalysisSchemes");
        request.addParameter("Version", "2013-01-01");
        request.setHttpMethod(HttpMethodName.POST);
        if (describeAnalysisSchemesRequest.getDomainName() != null) {
            request.addParameter("DomainName", StringUtils.fromString(describeAnalysisSchemesRequest.getDomainName()));
        }
        if (!describeAnalysisSchemesRequest.getAnalysisSchemeNames().isEmpty() || !((SdkInternalList)describeAnalysisSchemesRequest.getAnalysisSchemeNames()).isAutoConstruct()) {
            SdkInternalList analysisSchemeNamesList = (SdkInternalList)describeAnalysisSchemesRequest.getAnalysisSchemeNames();
            int analysisSchemeNamesListIndex = 1;
            for (String analysisSchemeNamesListValue : analysisSchemeNamesList) {
                if (analysisSchemeNamesListValue != null) {
                    request.addParameter("AnalysisSchemeNames.member." + analysisSchemeNamesListIndex, StringUtils.fromString(analysisSchemeNamesListValue));
                }
                ++analysisSchemeNamesListIndex;
            }
        }
        if (describeAnalysisSchemesRequest.getDeployed() != null) {
            request.addParameter("Deployed", StringUtils.fromBoolean(describeAnalysisSchemesRequest.getDeployed()));
        }
        return request;
    }
}

