/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.cloudfront.model.transform;

import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.SdkClientException;
import com.amazonaws.http.HttpMethodName;
import com.amazonaws.services.cloudfront.model.PublicKeyConfig;
import com.amazonaws.services.cloudfront.model.UpdatePublicKeyRequest;
import com.amazonaws.transform.Marshaller;
import com.amazonaws.transform.PathMarshallers;
import com.amazonaws.util.StringInputStream;
import com.amazonaws.util.StringUtils;
import com.amazonaws.util.XMLWriter;
import java.io.StringWriter;

public class UpdatePublicKeyRequestMarshaller
implements Marshaller<Request<UpdatePublicKeyRequest>, UpdatePublicKeyRequest> {
    @Override
    public Request<UpdatePublicKeyRequest> marshall(UpdatePublicKeyRequest updatePublicKeyRequest) {
        if (updatePublicKeyRequest == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest<UpdatePublicKeyRequest> request = new DefaultRequest<UpdatePublicKeyRequest>(updatePublicKeyRequest, "AmazonCloudFront");
        request.setHttpMethod(HttpMethodName.PUT);
        if (updatePublicKeyRequest.getIfMatch() != null) {
            request.addHeader("If-Match", StringUtils.fromString(updatePublicKeyRequest.getIfMatch()));
        }
        String uriResourcePath = "/2017-10-30/public-key/{Id}/config";
        uriResourcePath = PathMarshallers.NON_GREEDY.marshall(uriResourcePath, "Id", updatePublicKeyRequest.getId());
        request.setResourcePath(uriResourcePath);
        try {
            StringWriter stringWriter = new StringWriter();
            XMLWriter xmlWriter = new XMLWriter(stringWriter, "http://cloudfront.amazonaws.com/doc/2017-10-30/");
            PublicKeyConfig publicKeyConfig = updatePublicKeyRequest.getPublicKeyConfig();
            if (publicKeyConfig != null) {
                xmlWriter.startElement("PublicKeyConfig");
                if (publicKeyConfig.getCallerReference() != null) {
                    xmlWriter.startElement("CallerReference").value(publicKeyConfig.getCallerReference()).endElement();
                }
                if (publicKeyConfig.getName() != null) {
                    xmlWriter.startElement("Name").value(publicKeyConfig.getName()).endElement();
                }
                if (publicKeyConfig.getEncodedKey() != null) {
                    xmlWriter.startElement("EncodedKey").value(publicKeyConfig.getEncodedKey()).endElement();
                }
                if (publicKeyConfig.getComment() != null) {
                    xmlWriter.startElement("Comment").value(publicKeyConfig.getComment()).endElement();
                }
                xmlWriter.endElement();
            }
            request.setContent(new StringInputStream(stringWriter.getBuffer().toString()));
            request.addHeader("Content-Length", Integer.toString(stringWriter.getBuffer().toString().getBytes(StringUtils.UTF8).length));
            if (!request.getHeaders().containsKey("Content-Type")) {
                request.addHeader("Content-Type", "application/xml");
            }
        }
        catch (Throwable t) {
            throw new SdkClientException("Unable to marshall request to XML: " + t.getMessage(), t);
        }
        return request;
    }
}

