/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.cloudfront.model.transform;

import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.SdkClientException;
import com.amazonaws.http.HttpMethodName;
import com.amazonaws.services.cloudfront.model.ListStreamingDistributionsRequest;
import com.amazonaws.transform.Marshaller;
import com.amazonaws.util.StringUtils;

public class ListStreamingDistributionsRequestMarshaller
implements Marshaller<Request<ListStreamingDistributionsRequest>, ListStreamingDistributionsRequest> {
    @Override
    public Request<ListStreamingDistributionsRequest> marshall(ListStreamingDistributionsRequest listStreamingDistributionsRequest) {
        if (listStreamingDistributionsRequest == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest<ListStreamingDistributionsRequest> request = new DefaultRequest<ListStreamingDistributionsRequest>(listStreamingDistributionsRequest, "AmazonCloudFront");
        request.setHttpMethod(HttpMethodName.GET);
        String uriResourcePath = "/2017-10-30/streaming-distribution";
        request.setResourcePath(uriResourcePath);
        if (listStreamingDistributionsRequest.getMarker() != null) {
            request.addParameter("Marker", StringUtils.fromString(listStreamingDistributionsRequest.getMarker()));
        }
        if (listStreamingDistributionsRequest.getMaxItems() != null) {
            request.addParameter("MaxItems", StringUtils.fromString(listStreamingDistributionsRequest.getMaxItems()));
        }
        return request;
    }
}

