/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.cloudfront.model.transform;

import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.SdkClientException;
import com.amazonaws.http.HttpMethodName;
import com.amazonaws.services.cloudfront.model.ListDistributionsByWebACLIdRequest;
import com.amazonaws.transform.Marshaller;
import com.amazonaws.transform.PathMarshallers;
import com.amazonaws.util.StringUtils;

public class ListDistributionsByWebACLIdRequestMarshaller
implements Marshaller<Request<ListDistributionsByWebACLIdRequest>, ListDistributionsByWebACLIdRequest> {
    @Override
    public Request<ListDistributionsByWebACLIdRequest> marshall(ListDistributionsByWebACLIdRequest listDistributionsByWebACLIdRequest) {
        if (listDistributionsByWebACLIdRequest == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest<ListDistributionsByWebACLIdRequest> request = new DefaultRequest<ListDistributionsByWebACLIdRequest>(listDistributionsByWebACLIdRequest, "AmazonCloudFront");
        request.setHttpMethod(HttpMethodName.GET);
        String uriResourcePath = "/2017-10-30/distributionsByWebACLId/{WebACLId}";
        uriResourcePath = PathMarshallers.NON_GREEDY.marshall(uriResourcePath, "WebACLId", listDistributionsByWebACLIdRequest.getWebACLId());
        request.setResourcePath(uriResourcePath);
        if (listDistributionsByWebACLIdRequest.getMarker() != null) {
            request.addParameter("Marker", StringUtils.fromString(listDistributionsByWebACLIdRequest.getMarker()));
        }
        if (listDistributionsByWebACLIdRequest.getMaxItems() != null) {
            request.addParameter("MaxItems", StringUtils.fromString(listDistributionsByWebACLIdRequest.getMaxItems()));
        }
        return request;
    }
}

