/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.cloudfront.model.transform;

import com.amazonaws.services.cloudfront.model.FieldPatterns;
import com.amazonaws.transform.SimpleTypeStaxUnmarshallers;
import com.amazonaws.transform.StaxUnmarshallerContext;
import com.amazonaws.transform.Unmarshaller;
import java.util.ArrayList;
import javax.xml.stream.events.XMLEvent;

public class FieldPatternsStaxUnmarshaller
implements Unmarshaller<FieldPatterns, StaxUnmarshallerContext> {
    private static FieldPatternsStaxUnmarshaller instance;

    @Override
    public FieldPatterns unmarshall(StaxUnmarshallerContext context) throws Exception {
        FieldPatterns fieldPatterns = new FieldPatterns();
        int originalDepth = context.getCurrentDepth();
        int targetDepth = originalDepth + 1;
        if (context.isStartOfDocument()) {
            ++targetDepth;
        }
        while (true) {
            XMLEvent xmlEvent;
            if ((xmlEvent = context.nextEvent()).isEndDocument()) {
                return fieldPatterns;
            }
            if (xmlEvent.isAttribute() || xmlEvent.isStartElement()) {
                if (context.testExpression("Quantity", targetDepth)) {
                    fieldPatterns.setQuantity(SimpleTypeStaxUnmarshallers.IntegerStaxUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (context.testExpression("Items", targetDepth)) {
                    fieldPatterns.withItems(new ArrayList<String>());
                    continue;
                }
                if (!context.testExpression("Items/FieldPattern", targetDepth)) continue;
                fieldPatterns.withItems(SimpleTypeStaxUnmarshallers.StringStaxUnmarshaller.getInstance().unmarshall(context));
                continue;
            }
            if (xmlEvent.isEndElement() && context.getCurrentDepth() < originalDepth) break;
        }
        return fieldPatterns;
    }

    public static FieldPatternsStaxUnmarshaller getInstance() {
        if (instance == null) {
            instance = new FieldPatternsStaxUnmarshaller();
        }
        return instance;
    }
}

