/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.cloudfront.model.transform;

import com.amazonaws.services.cloudfront.model.EncryptionEntity;
import com.amazonaws.services.cloudfront.model.transform.FieldPatternsStaxUnmarshaller;
import com.amazonaws.transform.SimpleTypeStaxUnmarshallers;
import com.amazonaws.transform.StaxUnmarshallerContext;
import com.amazonaws.transform.Unmarshaller;
import javax.xml.stream.events.XMLEvent;

public class EncryptionEntityStaxUnmarshaller
implements Unmarshaller<EncryptionEntity, StaxUnmarshallerContext> {
    private static EncryptionEntityStaxUnmarshaller instance;

    @Override
    public EncryptionEntity unmarshall(StaxUnmarshallerContext context) throws Exception {
        EncryptionEntity encryptionEntity = new EncryptionEntity();
        int originalDepth = context.getCurrentDepth();
        int targetDepth = originalDepth + 1;
        if (context.isStartOfDocument()) {
            ++targetDepth;
        }
        while (true) {
            XMLEvent xmlEvent;
            if ((xmlEvent = context.nextEvent()).isEndDocument()) {
                return encryptionEntity;
            }
            if (xmlEvent.isAttribute() || xmlEvent.isStartElement()) {
                if (context.testExpression("PublicKeyId", targetDepth)) {
                    encryptionEntity.setPublicKeyId(SimpleTypeStaxUnmarshallers.StringStaxUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (context.testExpression("ProviderId", targetDepth)) {
                    encryptionEntity.setProviderId(SimpleTypeStaxUnmarshallers.StringStaxUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (!context.testExpression("FieldPatterns", targetDepth)) continue;
                encryptionEntity.setFieldPatterns(FieldPatternsStaxUnmarshaller.getInstance().unmarshall(context));
                continue;
            }
            if (xmlEvent.isEndElement() && context.getCurrentDepth() < originalDepth) break;
        }
        return encryptionEntity;
    }

    public static EncryptionEntityStaxUnmarshaller getInstance() {
        if (instance == null) {
            instance = new EncryptionEntityStaxUnmarshaller();
        }
        return instance;
    }
}

