/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.cloudfront.model.transform;

import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.SdkClientException;
import com.amazonaws.http.HttpMethodName;
import com.amazonaws.services.cloudfront.model.DeletePublicKeyRequest;
import com.amazonaws.transform.Marshaller;
import com.amazonaws.transform.PathMarshallers;
import com.amazonaws.util.StringUtils;

public class DeletePublicKeyRequestMarshaller
implements Marshaller<Request<DeletePublicKeyRequest>, DeletePublicKeyRequest> {
    @Override
    public Request<DeletePublicKeyRequest> marshall(DeletePublicKeyRequest deletePublicKeyRequest) {
        if (deletePublicKeyRequest == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest<DeletePublicKeyRequest> request = new DefaultRequest<DeletePublicKeyRequest>(deletePublicKeyRequest, "AmazonCloudFront");
        request.setHttpMethod(HttpMethodName.DELETE);
        if (deletePublicKeyRequest.getIfMatch() != null) {
            request.addHeader("If-Match", StringUtils.fromString(deletePublicKeyRequest.getIfMatch()));
        }
        String uriResourcePath = "/2017-10-30/public-key/{Id}";
        uriResourcePath = PathMarshallers.NON_GREEDY.marshall(uriResourcePath, "Id", deletePublicKeyRequest.getId());
        request.setResourcePath(uriResourcePath);
        return request;
    }
}

