/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.cloudfront.model.transform;

import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.SdkClientException;
import com.amazonaws.http.HttpMethodName;
import com.amazonaws.internal.SdkInternalList;
import com.amazonaws.services.cloudfront.model.CreateFieldLevelEncryptionProfileRequest;
import com.amazonaws.services.cloudfront.model.EncryptionEntities;
import com.amazonaws.services.cloudfront.model.EncryptionEntity;
import com.amazonaws.services.cloudfront.model.FieldLevelEncryptionProfileConfig;
import com.amazonaws.services.cloudfront.model.FieldPatterns;
import com.amazonaws.transform.Marshaller;
import com.amazonaws.util.StringInputStream;
import com.amazonaws.util.StringUtils;
import com.amazonaws.util.XMLWriter;
import java.io.StringWriter;

public class CreateFieldLevelEncryptionProfileRequestMarshaller
implements Marshaller<Request<CreateFieldLevelEncryptionProfileRequest>, CreateFieldLevelEncryptionProfileRequest> {
    @Override
    public Request<CreateFieldLevelEncryptionProfileRequest> marshall(CreateFieldLevelEncryptionProfileRequest createFieldLevelEncryptionProfileRequest) {
        if (createFieldLevelEncryptionProfileRequest == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest<CreateFieldLevelEncryptionProfileRequest> request = new DefaultRequest<CreateFieldLevelEncryptionProfileRequest>(createFieldLevelEncryptionProfileRequest, "AmazonCloudFront");
        request.setHttpMethod(HttpMethodName.POST);
        String uriResourcePath = "/2017-10-30/field-level-encryption-profile";
        request.setResourcePath(uriResourcePath);
        try {
            StringWriter stringWriter = new StringWriter();
            XMLWriter xmlWriter = new XMLWriter(stringWriter, "http://cloudfront.amazonaws.com/doc/2017-10-30/");
            FieldLevelEncryptionProfileConfig fieldLevelEncryptionProfileConfig = createFieldLevelEncryptionProfileRequest.getFieldLevelEncryptionProfileConfig();
            if (fieldLevelEncryptionProfileConfig != null) {
                EncryptionEntities encryptionEntities;
                xmlWriter.startElement("FieldLevelEncryptionProfileConfig");
                if (fieldLevelEncryptionProfileConfig.getName() != null) {
                    xmlWriter.startElement("Name").value(fieldLevelEncryptionProfileConfig.getName()).endElement();
                }
                if (fieldLevelEncryptionProfileConfig.getCallerReference() != null) {
                    xmlWriter.startElement("CallerReference").value(fieldLevelEncryptionProfileConfig.getCallerReference()).endElement();
                }
                if (fieldLevelEncryptionProfileConfig.getComment() != null) {
                    xmlWriter.startElement("Comment").value(fieldLevelEncryptionProfileConfig.getComment()).endElement();
                }
                if ((encryptionEntities = fieldLevelEncryptionProfileConfig.getEncryptionEntities()) != null) {
                    SdkInternalList encryptionEntitiesItemsList;
                    xmlWriter.startElement("EncryptionEntities");
                    if (encryptionEntities.getQuantity() != null) {
                        xmlWriter.startElement("Quantity").value(encryptionEntities.getQuantity()).endElement();
                    }
                    if (!(encryptionEntitiesItemsList = (SdkInternalList)encryptionEntities.getItems()).isEmpty() || !encryptionEntitiesItemsList.isAutoConstruct()) {
                        xmlWriter.startElement("Items");
                        for (EncryptionEntity encryptionEntitiesItemsListValue : encryptionEntitiesItemsList) {
                            FieldPatterns fieldPatterns;
                            xmlWriter.startElement("EncryptionEntity");
                            if (encryptionEntitiesItemsListValue.getPublicKeyId() != null) {
                                xmlWriter.startElement("PublicKeyId").value(encryptionEntitiesItemsListValue.getPublicKeyId()).endElement();
                            }
                            if (encryptionEntitiesItemsListValue.getProviderId() != null) {
                                xmlWriter.startElement("ProviderId").value(encryptionEntitiesItemsListValue.getProviderId()).endElement();
                            }
                            if ((fieldPatterns = encryptionEntitiesItemsListValue.getFieldPatterns()) != null) {
                                SdkInternalList fieldPatternsItemsList;
                                xmlWriter.startElement("FieldPatterns");
                                if (fieldPatterns.getQuantity() != null) {
                                    xmlWriter.startElement("Quantity").value(fieldPatterns.getQuantity()).endElement();
                                }
                                if (!(fieldPatternsItemsList = (SdkInternalList)fieldPatterns.getItems()).isEmpty() || !fieldPatternsItemsList.isAutoConstruct()) {
                                    xmlWriter.startElement("Items");
                                    for (String fieldPatternsItemsListValue : fieldPatternsItemsList) {
                                        xmlWriter.startElement("FieldPattern");
                                        xmlWriter.value(fieldPatternsItemsListValue);
                                        xmlWriter.endElement();
                                    }
                                    xmlWriter.endElement();
                                }
                                xmlWriter.endElement();
                            }
                            xmlWriter.endElement();
                        }
                        xmlWriter.endElement();
                    }
                    xmlWriter.endElement();
                }
                xmlWriter.endElement();
            }
            request.setContent(new StringInputStream(stringWriter.getBuffer().toString()));
            request.addHeader("Content-Length", Integer.toString(stringWriter.getBuffer().toString().getBytes(StringUtils.UTF8).length));
            if (!request.getHeaders().containsKey("Content-Type")) {
                request.addHeader("Content-Type", "application/xml");
            }
        }
        catch (Throwable t) {
            throw new SdkClientException("Unable to marshall request to XML: " + t.getMessage(), t);
        }
        return request;
    }
}

