/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.cloudformation.model.transform;

import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.SdkClientException;
import com.amazonaws.http.HttpMethodName;
import com.amazonaws.internal.SdkInternalList;
import com.amazonaws.services.cloudformation.model.CreateChangeSetRequest;
import com.amazonaws.services.cloudformation.model.Parameter;
import com.amazonaws.services.cloudformation.model.RollbackConfiguration;
import com.amazonaws.services.cloudformation.model.RollbackTrigger;
import com.amazonaws.services.cloudformation.model.Tag;
import com.amazonaws.transform.Marshaller;
import com.amazonaws.util.StringUtils;

public class CreateChangeSetRequestMarshaller
implements Marshaller<Request<CreateChangeSetRequest>, CreateChangeSetRequest> {
    @Override
    public Request<CreateChangeSetRequest> marshall(CreateChangeSetRequest createChangeSetRequest) {
        RollbackConfiguration rollbackConfiguration;
        if (createChangeSetRequest == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest<CreateChangeSetRequest> request = new DefaultRequest<CreateChangeSetRequest>(createChangeSetRequest, "AmazonCloudFormation");
        request.addParameter("Action", "CreateChangeSet");
        request.addParameter("Version", "2010-05-15");
        request.setHttpMethod(HttpMethodName.POST);
        if (createChangeSetRequest.getStackName() != null) {
            request.addParameter("StackName", StringUtils.fromString(createChangeSetRequest.getStackName()));
        }
        if (createChangeSetRequest.getTemplateBody() != null) {
            request.addParameter("TemplateBody", StringUtils.fromString(createChangeSetRequest.getTemplateBody()));
        }
        if (createChangeSetRequest.getTemplateURL() != null) {
            request.addParameter("TemplateURL", StringUtils.fromString(createChangeSetRequest.getTemplateURL()));
        }
        if (createChangeSetRequest.getUsePreviousTemplate() != null) {
            request.addParameter("UsePreviousTemplate", StringUtils.fromBoolean(createChangeSetRequest.getUsePreviousTemplate()));
        }
        if (createChangeSetRequest.getParameters().isEmpty() && !((SdkInternalList)createChangeSetRequest.getParameters()).isAutoConstruct()) {
            request.addParameter("Parameters", "");
        }
        if (!createChangeSetRequest.getParameters().isEmpty() || !((SdkInternalList)createChangeSetRequest.getParameters()).isAutoConstruct()) {
            SdkInternalList parametersList = (SdkInternalList)createChangeSetRequest.getParameters();
            int parametersListIndex = 1;
            for (Parameter parametersListValue : parametersList) {
                if (parametersListValue.getParameterKey() != null) {
                    request.addParameter("Parameters.member." + parametersListIndex + ".ParameterKey", StringUtils.fromString(parametersListValue.getParameterKey()));
                }
                if (parametersListValue.getParameterValue() != null) {
                    request.addParameter("Parameters.member." + parametersListIndex + ".ParameterValue", StringUtils.fromString(parametersListValue.getParameterValue()));
                }
                if (parametersListValue.getUsePreviousValue() != null) {
                    request.addParameter("Parameters.member." + parametersListIndex + ".UsePreviousValue", StringUtils.fromBoolean(parametersListValue.getUsePreviousValue()));
                }
                if (parametersListValue.getResolvedValue() != null) {
                    request.addParameter("Parameters.member." + parametersListIndex + ".ResolvedValue", StringUtils.fromString(parametersListValue.getResolvedValue()));
                }
                ++parametersListIndex;
            }
        }
        if (createChangeSetRequest.getCapabilities().isEmpty() && !((SdkInternalList)createChangeSetRequest.getCapabilities()).isAutoConstruct()) {
            request.addParameter("Capabilities", "");
        }
        if (!createChangeSetRequest.getCapabilities().isEmpty() || !((SdkInternalList)createChangeSetRequest.getCapabilities()).isAutoConstruct()) {
            SdkInternalList capabilitiesList = (SdkInternalList)createChangeSetRequest.getCapabilities();
            int capabilitiesListIndex = 1;
            for (String capabilitiesListValue : capabilitiesList) {
                if (capabilitiesListValue != null) {
                    request.addParameter("Capabilities.member." + capabilitiesListIndex, StringUtils.fromString(capabilitiesListValue));
                }
                ++capabilitiesListIndex;
            }
        }
        if (createChangeSetRequest.getResourceTypes().isEmpty() && !((SdkInternalList)createChangeSetRequest.getResourceTypes()).isAutoConstruct()) {
            request.addParameter("ResourceTypes", "");
        }
        if (!createChangeSetRequest.getResourceTypes().isEmpty() || !((SdkInternalList)createChangeSetRequest.getResourceTypes()).isAutoConstruct()) {
            SdkInternalList resourceTypesList = (SdkInternalList)createChangeSetRequest.getResourceTypes();
            int resourceTypesListIndex = 1;
            for (String resourceTypesListValue : resourceTypesList) {
                if (resourceTypesListValue != null) {
                    request.addParameter("ResourceTypes.member." + resourceTypesListIndex, StringUtils.fromString(resourceTypesListValue));
                }
                ++resourceTypesListIndex;
            }
        }
        if (createChangeSetRequest.getRoleARN() != null) {
            request.addParameter("RoleARN", StringUtils.fromString(createChangeSetRequest.getRoleARN()));
        }
        if ((rollbackConfiguration = createChangeSetRequest.getRollbackConfiguration()) != null) {
            if (rollbackConfiguration.getRollbackTriggers().isEmpty() && !((SdkInternalList)rollbackConfiguration.getRollbackTriggers()).isAutoConstruct()) {
                request.addParameter("RollbackConfiguration.RollbackTriggers", "");
            }
            if (!rollbackConfiguration.getRollbackTriggers().isEmpty() || !((SdkInternalList)rollbackConfiguration.getRollbackTriggers()).isAutoConstruct()) {
                SdkInternalList rollbackTriggersList = (SdkInternalList)rollbackConfiguration.getRollbackTriggers();
                int rollbackTriggersListIndex = 1;
                for (RollbackTrigger rollbackTriggersListValue : rollbackTriggersList) {
                    if (rollbackTriggersListValue.getArn() != null) {
                        request.addParameter("RollbackConfiguration.RollbackTriggers.member." + rollbackTriggersListIndex + ".Arn", StringUtils.fromString(rollbackTriggersListValue.getArn()));
                    }
                    if (rollbackTriggersListValue.getType() != null) {
                        request.addParameter("RollbackConfiguration.RollbackTriggers.member." + rollbackTriggersListIndex + ".Type", StringUtils.fromString(rollbackTriggersListValue.getType()));
                    }
                    ++rollbackTriggersListIndex;
                }
            }
            if (rollbackConfiguration.getMonitoringTimeInMinutes() != null) {
                request.addParameter("RollbackConfiguration.MonitoringTimeInMinutes", StringUtils.fromInteger(rollbackConfiguration.getMonitoringTimeInMinutes()));
            }
        }
        if (createChangeSetRequest.getNotificationARNs().isEmpty() && !((SdkInternalList)createChangeSetRequest.getNotificationARNs()).isAutoConstruct()) {
            request.addParameter("NotificationARNs", "");
        }
        if (!createChangeSetRequest.getNotificationARNs().isEmpty() || !((SdkInternalList)createChangeSetRequest.getNotificationARNs()).isAutoConstruct()) {
            SdkInternalList notificationARNsList = (SdkInternalList)createChangeSetRequest.getNotificationARNs();
            int notificationARNsListIndex = 1;
            for (String notificationARNsListValue : notificationARNsList) {
                if (notificationARNsListValue != null) {
                    request.addParameter("NotificationARNs.member." + notificationARNsListIndex, StringUtils.fromString(notificationARNsListValue));
                }
                ++notificationARNsListIndex;
            }
        }
        if (createChangeSetRequest.getTags().isEmpty() && !((SdkInternalList)createChangeSetRequest.getTags()).isAutoConstruct()) {
            request.addParameter("Tags", "");
        }
        if (!createChangeSetRequest.getTags().isEmpty() || !((SdkInternalList)createChangeSetRequest.getTags()).isAutoConstruct()) {
            SdkInternalList tagsList = (SdkInternalList)createChangeSetRequest.getTags();
            int tagsListIndex = 1;
            for (Tag tagsListValue : tagsList) {
                if (tagsListValue.getKey() != null) {
                    request.addParameter("Tags.member." + tagsListIndex + ".Key", StringUtils.fromString(tagsListValue.getKey()));
                }
                if (tagsListValue.getValue() != null) {
                    request.addParameter("Tags.member." + tagsListIndex + ".Value", StringUtils.fromString(tagsListValue.getValue()));
                }
                ++tagsListIndex;
            }
        }
        if (createChangeSetRequest.getChangeSetName() != null) {
            request.addParameter("ChangeSetName", StringUtils.fromString(createChangeSetRequest.getChangeSetName()));
        }
        if (createChangeSetRequest.getClientToken() != null) {
            request.addParameter("ClientToken", StringUtils.fromString(createChangeSetRequest.getClientToken()));
        }
        if (createChangeSetRequest.getDescription() != null) {
            request.addParameter("Description", StringUtils.fromString(createChangeSetRequest.getDescription()));
        }
        if (createChangeSetRequest.getChangeSetType() != null) {
            request.addParameter("ChangeSetType", StringUtils.fromString(createChangeSetRequest.getChangeSetType()));
        }
        return request;
    }
}

