/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.certificatemanager;

import com.amazonaws.ClientConfiguration;
import com.amazonaws.annotation.ThreadSafe;
import com.amazonaws.auth.AWSCredentials;
import com.amazonaws.auth.AWSCredentialsProvider;
import com.amazonaws.auth.DefaultAWSCredentialsProviderChain;
import com.amazonaws.client.AwsAsyncClientParams;
import com.amazonaws.handlers.AsyncHandler;
import com.amazonaws.services.certificatemanager.AWSCertificateManagerAsync;
import com.amazonaws.services.certificatemanager.AWSCertificateManagerAsyncClientBuilder;
import com.amazonaws.services.certificatemanager.AWSCertificateManagerClient;
import com.amazonaws.services.certificatemanager.model.AddTagsToCertificateRequest;
import com.amazonaws.services.certificatemanager.model.AddTagsToCertificateResult;
import com.amazonaws.services.certificatemanager.model.DeleteCertificateRequest;
import com.amazonaws.services.certificatemanager.model.DeleteCertificateResult;
import com.amazonaws.services.certificatemanager.model.DescribeCertificateRequest;
import com.amazonaws.services.certificatemanager.model.DescribeCertificateResult;
import com.amazonaws.services.certificatemanager.model.GetCertificateRequest;
import com.amazonaws.services.certificatemanager.model.GetCertificateResult;
import com.amazonaws.services.certificatemanager.model.ImportCertificateRequest;
import com.amazonaws.services.certificatemanager.model.ImportCertificateResult;
import com.amazonaws.services.certificatemanager.model.ListCertificatesRequest;
import com.amazonaws.services.certificatemanager.model.ListCertificatesResult;
import com.amazonaws.services.certificatemanager.model.ListTagsForCertificateRequest;
import com.amazonaws.services.certificatemanager.model.ListTagsForCertificateResult;
import com.amazonaws.services.certificatemanager.model.RemoveTagsFromCertificateRequest;
import com.amazonaws.services.certificatemanager.model.RemoveTagsFromCertificateResult;
import com.amazonaws.services.certificatemanager.model.RequestCertificateRequest;
import com.amazonaws.services.certificatemanager.model.RequestCertificateResult;
import com.amazonaws.services.certificatemanager.model.ResendValidationEmailRequest;
import com.amazonaws.services.certificatemanager.model.ResendValidationEmailResult;
import com.amazonaws.services.certificatemanager.model.UpdateCertificateOptionsRequest;
import com.amazonaws.services.certificatemanager.model.UpdateCertificateOptionsResult;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;

@ThreadSafe
public class AWSCertificateManagerAsyncClient
extends AWSCertificateManagerClient
implements AWSCertificateManagerAsync {
    private static final int DEFAULT_THREAD_POOL_SIZE = 50;
    private final ExecutorService executorService;

    @Deprecated
    public AWSCertificateManagerAsyncClient() {
        this(DefaultAWSCredentialsProviderChain.getInstance());
    }

    @Deprecated
    public AWSCertificateManagerAsyncClient(ClientConfiguration clientConfiguration) {
        this((AWSCredentialsProvider)DefaultAWSCredentialsProviderChain.getInstance(), clientConfiguration, Executors.newFixedThreadPool(clientConfiguration.getMaxConnections()));
    }

    @Deprecated
    public AWSCertificateManagerAsyncClient(AWSCredentials awsCredentials) {
        this(awsCredentials, Executors.newFixedThreadPool(50));
    }

    @Deprecated
    public AWSCertificateManagerAsyncClient(AWSCredentials awsCredentials, ExecutorService executorService) {
        this(awsCredentials, configFactory.getConfig(), executorService);
    }

    @Deprecated
    public AWSCertificateManagerAsyncClient(AWSCredentials awsCredentials, ClientConfiguration clientConfiguration, ExecutorService executorService) {
        super(awsCredentials, clientConfiguration);
        this.executorService = executorService;
    }

    @Deprecated
    public AWSCertificateManagerAsyncClient(AWSCredentialsProvider awsCredentialsProvider) {
        this(awsCredentialsProvider, Executors.newFixedThreadPool(50));
    }

    @Deprecated
    public AWSCertificateManagerAsyncClient(AWSCredentialsProvider awsCredentialsProvider, ClientConfiguration clientConfiguration) {
        this(awsCredentialsProvider, clientConfiguration, Executors.newFixedThreadPool(clientConfiguration.getMaxConnections()));
    }

    @Deprecated
    public AWSCertificateManagerAsyncClient(AWSCredentialsProvider awsCredentialsProvider, ExecutorService executorService) {
        this(awsCredentialsProvider, configFactory.getConfig(), executorService);
    }

    @Deprecated
    public AWSCertificateManagerAsyncClient(AWSCredentialsProvider awsCredentialsProvider, ClientConfiguration clientConfiguration, ExecutorService executorService) {
        super(awsCredentialsProvider, clientConfiguration);
        this.executorService = executorService;
    }

    public static AWSCertificateManagerAsyncClientBuilder asyncBuilder() {
        return AWSCertificateManagerAsyncClientBuilder.standard();
    }

    AWSCertificateManagerAsyncClient(AwsAsyncClientParams asyncClientParams) {
        super(asyncClientParams);
        this.executorService = asyncClientParams.getExecutor();
    }

    public ExecutorService getExecutorService() {
        return this.executorService;
    }

    @Override
    public Future<AddTagsToCertificateResult> addTagsToCertificateAsync(AddTagsToCertificateRequest request) {
        return this.addTagsToCertificateAsync(request, null);
    }

    @Override
    public Future<AddTagsToCertificateResult> addTagsToCertificateAsync(AddTagsToCertificateRequest request, final AsyncHandler<AddTagsToCertificateRequest, AddTagsToCertificateResult> asyncHandler) {
        final AddTagsToCertificateRequest finalRequest = this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<AddTagsToCertificateResult>(){

            @Override
            public AddTagsToCertificateResult call() throws Exception {
                AddTagsToCertificateResult result = null;
                try {
                    result = AWSCertificateManagerAsyncClient.this.executeAddTagsToCertificate(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess(finalRequest, result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<DeleteCertificateResult> deleteCertificateAsync(DeleteCertificateRequest request) {
        return this.deleteCertificateAsync(request, null);
    }

    @Override
    public Future<DeleteCertificateResult> deleteCertificateAsync(DeleteCertificateRequest request, final AsyncHandler<DeleteCertificateRequest, DeleteCertificateResult> asyncHandler) {
        final DeleteCertificateRequest finalRequest = this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<DeleteCertificateResult>(){

            @Override
            public DeleteCertificateResult call() throws Exception {
                DeleteCertificateResult result = null;
                try {
                    result = AWSCertificateManagerAsyncClient.this.executeDeleteCertificate(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess(finalRequest, result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<DescribeCertificateResult> describeCertificateAsync(DescribeCertificateRequest request) {
        return this.describeCertificateAsync(request, null);
    }

    @Override
    public Future<DescribeCertificateResult> describeCertificateAsync(DescribeCertificateRequest request, final AsyncHandler<DescribeCertificateRequest, DescribeCertificateResult> asyncHandler) {
        final DescribeCertificateRequest finalRequest = this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<DescribeCertificateResult>(){

            @Override
            public DescribeCertificateResult call() throws Exception {
                DescribeCertificateResult result = null;
                try {
                    result = AWSCertificateManagerAsyncClient.this.executeDescribeCertificate(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess(finalRequest, result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<GetCertificateResult> getCertificateAsync(GetCertificateRequest request) {
        return this.getCertificateAsync(request, null);
    }

    @Override
    public Future<GetCertificateResult> getCertificateAsync(GetCertificateRequest request, final AsyncHandler<GetCertificateRequest, GetCertificateResult> asyncHandler) {
        final GetCertificateRequest finalRequest = this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<GetCertificateResult>(){

            @Override
            public GetCertificateResult call() throws Exception {
                GetCertificateResult result = null;
                try {
                    result = AWSCertificateManagerAsyncClient.this.executeGetCertificate(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess(finalRequest, result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<ImportCertificateResult> importCertificateAsync(ImportCertificateRequest request) {
        return this.importCertificateAsync(request, null);
    }

    @Override
    public Future<ImportCertificateResult> importCertificateAsync(ImportCertificateRequest request, final AsyncHandler<ImportCertificateRequest, ImportCertificateResult> asyncHandler) {
        final ImportCertificateRequest finalRequest = this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<ImportCertificateResult>(){

            @Override
            public ImportCertificateResult call() throws Exception {
                ImportCertificateResult result = null;
                try {
                    result = AWSCertificateManagerAsyncClient.this.executeImportCertificate(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess(finalRequest, result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<ListCertificatesResult> listCertificatesAsync(ListCertificatesRequest request) {
        return this.listCertificatesAsync(request, null);
    }

    @Override
    public Future<ListCertificatesResult> listCertificatesAsync(ListCertificatesRequest request, final AsyncHandler<ListCertificatesRequest, ListCertificatesResult> asyncHandler) {
        final ListCertificatesRequest finalRequest = this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<ListCertificatesResult>(){

            @Override
            public ListCertificatesResult call() throws Exception {
                ListCertificatesResult result = null;
                try {
                    result = AWSCertificateManagerAsyncClient.this.executeListCertificates(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess(finalRequest, result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<ListTagsForCertificateResult> listTagsForCertificateAsync(ListTagsForCertificateRequest request) {
        return this.listTagsForCertificateAsync(request, null);
    }

    @Override
    public Future<ListTagsForCertificateResult> listTagsForCertificateAsync(ListTagsForCertificateRequest request, final AsyncHandler<ListTagsForCertificateRequest, ListTagsForCertificateResult> asyncHandler) {
        final ListTagsForCertificateRequest finalRequest = this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<ListTagsForCertificateResult>(){

            @Override
            public ListTagsForCertificateResult call() throws Exception {
                ListTagsForCertificateResult result = null;
                try {
                    result = AWSCertificateManagerAsyncClient.this.executeListTagsForCertificate(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess(finalRequest, result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<RemoveTagsFromCertificateResult> removeTagsFromCertificateAsync(RemoveTagsFromCertificateRequest request) {
        return this.removeTagsFromCertificateAsync(request, null);
    }

    @Override
    public Future<RemoveTagsFromCertificateResult> removeTagsFromCertificateAsync(RemoveTagsFromCertificateRequest request, final AsyncHandler<RemoveTagsFromCertificateRequest, RemoveTagsFromCertificateResult> asyncHandler) {
        final RemoveTagsFromCertificateRequest finalRequest = this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<RemoveTagsFromCertificateResult>(){

            @Override
            public RemoveTagsFromCertificateResult call() throws Exception {
                RemoveTagsFromCertificateResult result = null;
                try {
                    result = AWSCertificateManagerAsyncClient.this.executeRemoveTagsFromCertificate(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess(finalRequest, result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<RequestCertificateResult> requestCertificateAsync(RequestCertificateRequest request) {
        return this.requestCertificateAsync(request, null);
    }

    @Override
    public Future<RequestCertificateResult> requestCertificateAsync(RequestCertificateRequest request, final AsyncHandler<RequestCertificateRequest, RequestCertificateResult> asyncHandler) {
        final RequestCertificateRequest finalRequest = this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<RequestCertificateResult>(){

            @Override
            public RequestCertificateResult call() throws Exception {
                RequestCertificateResult result = null;
                try {
                    result = AWSCertificateManagerAsyncClient.this.executeRequestCertificate(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess(finalRequest, result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<ResendValidationEmailResult> resendValidationEmailAsync(ResendValidationEmailRequest request) {
        return this.resendValidationEmailAsync(request, null);
    }

    @Override
    public Future<ResendValidationEmailResult> resendValidationEmailAsync(ResendValidationEmailRequest request, final AsyncHandler<ResendValidationEmailRequest, ResendValidationEmailResult> asyncHandler) {
        final ResendValidationEmailRequest finalRequest = this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<ResendValidationEmailResult>(){

            @Override
            public ResendValidationEmailResult call() throws Exception {
                ResendValidationEmailResult result = null;
                try {
                    result = AWSCertificateManagerAsyncClient.this.executeResendValidationEmail(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess(finalRequest, result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<UpdateCertificateOptionsResult> updateCertificateOptionsAsync(UpdateCertificateOptionsRequest request) {
        return this.updateCertificateOptionsAsync(request, null);
    }

    @Override
    public Future<UpdateCertificateOptionsResult> updateCertificateOptionsAsync(UpdateCertificateOptionsRequest request, final AsyncHandler<UpdateCertificateOptionsRequest, UpdateCertificateOptionsResult> asyncHandler) {
        final UpdateCertificateOptionsRequest finalRequest = this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<UpdateCertificateOptionsResult>(){

            @Override
            public UpdateCertificateOptionsResult call() throws Exception {
                UpdateCertificateOptionsResult result = null;
                try {
                    result = AWSCertificateManagerAsyncClient.this.executeUpdateCertificateOptions(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess(finalRequest, result);
                }
                return result;
            }
        });
    }

    @Override
    public void shutdown() {
        super.shutdown();
        this.executorService.shutdownNow();
    }
}

