/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.autoscaling.model.transform;

import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.SdkClientException;
import com.amazonaws.http.HttpMethodName;
import com.amazonaws.internal.SdkInternalList;
import com.amazonaws.services.autoscaling.model.SetInstanceProtectionRequest;
import com.amazonaws.transform.Marshaller;
import com.amazonaws.util.StringUtils;

public class SetInstanceProtectionRequestMarshaller
implements Marshaller<Request<SetInstanceProtectionRequest>, SetInstanceProtectionRequest> {
    @Override
    public Request<SetInstanceProtectionRequest> marshall(SetInstanceProtectionRequest setInstanceProtectionRequest) {
        if (setInstanceProtectionRequest == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest<SetInstanceProtectionRequest> request = new DefaultRequest<SetInstanceProtectionRequest>(setInstanceProtectionRequest, "AmazonAutoScaling");
        request.addParameter("Action", "SetInstanceProtection");
        request.addParameter("Version", "2011-01-01");
        request.setHttpMethod(HttpMethodName.POST);
        if (!setInstanceProtectionRequest.getInstanceIds().isEmpty() || !((SdkInternalList)setInstanceProtectionRequest.getInstanceIds()).isAutoConstruct()) {
            SdkInternalList instanceIdsList = (SdkInternalList)setInstanceProtectionRequest.getInstanceIds();
            int instanceIdsListIndex = 1;
            for (String instanceIdsListValue : instanceIdsList) {
                if (instanceIdsListValue != null) {
                    request.addParameter("InstanceIds.member." + instanceIdsListIndex, StringUtils.fromString(instanceIdsListValue));
                }
                ++instanceIdsListIndex;
            }
        }
        if (setInstanceProtectionRequest.getAutoScalingGroupName() != null) {
            request.addParameter("AutoScalingGroupName", StringUtils.fromString(setInstanceProtectionRequest.getAutoScalingGroupName()));
        }
        if (setInstanceProtectionRequest.getProtectedFromScaleIn() != null) {
            request.addParameter("ProtectedFromScaleIn", StringUtils.fromBoolean(setInstanceProtectionRequest.getProtectedFromScaleIn()));
        }
        return request;
    }
}

