/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.autoscaling.model.transform;

import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.SdkClientException;
import com.amazonaws.http.HttpMethodName;
import com.amazonaws.internal.SdkInternalList;
import com.amazonaws.services.autoscaling.model.ResumeProcessesRequest;
import com.amazonaws.transform.Marshaller;
import com.amazonaws.util.StringUtils;

public class ResumeProcessesRequestMarshaller
implements Marshaller<Request<ResumeProcessesRequest>, ResumeProcessesRequest> {
    @Override
    public Request<ResumeProcessesRequest> marshall(ResumeProcessesRequest resumeProcessesRequest) {
        if (resumeProcessesRequest == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest<ResumeProcessesRequest> request = new DefaultRequest<ResumeProcessesRequest>(resumeProcessesRequest, "AmazonAutoScaling");
        request.addParameter("Action", "ResumeProcesses");
        request.addParameter("Version", "2011-01-01");
        request.setHttpMethod(HttpMethodName.POST);
        if (resumeProcessesRequest.getAutoScalingGroupName() != null) {
            request.addParameter("AutoScalingGroupName", StringUtils.fromString(resumeProcessesRequest.getAutoScalingGroupName()));
        }
        if (!resumeProcessesRequest.getScalingProcesses().isEmpty() || !((SdkInternalList)resumeProcessesRequest.getScalingProcesses()).isAutoConstruct()) {
            SdkInternalList scalingProcessesList = (SdkInternalList)resumeProcessesRequest.getScalingProcesses();
            int scalingProcessesListIndex = 1;
            for (String scalingProcessesListValue : scalingProcessesList) {
                if (scalingProcessesListValue != null) {
                    request.addParameter("ScalingProcesses.member." + scalingProcessesListIndex, StringUtils.fromString(scalingProcessesListValue));
                }
                ++scalingProcessesListIndex;
            }
        }
        return request;
    }
}

