/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.autoscaling.model.transform;

import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.SdkClientException;
import com.amazonaws.http.HttpMethodName;
import com.amazonaws.internal.SdkInternalList;
import com.amazonaws.services.autoscaling.model.DetachInstancesRequest;
import com.amazonaws.transform.Marshaller;
import com.amazonaws.util.StringUtils;

public class DetachInstancesRequestMarshaller
implements Marshaller<Request<DetachInstancesRequest>, DetachInstancesRequest> {
    @Override
    public Request<DetachInstancesRequest> marshall(DetachInstancesRequest detachInstancesRequest) {
        if (detachInstancesRequest == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest<DetachInstancesRequest> request = new DefaultRequest<DetachInstancesRequest>(detachInstancesRequest, "AmazonAutoScaling");
        request.addParameter("Action", "DetachInstances");
        request.addParameter("Version", "2011-01-01");
        request.setHttpMethod(HttpMethodName.POST);
        if (!detachInstancesRequest.getInstanceIds().isEmpty() || !((SdkInternalList)detachInstancesRequest.getInstanceIds()).isAutoConstruct()) {
            SdkInternalList instanceIdsList = (SdkInternalList)detachInstancesRequest.getInstanceIds();
            int instanceIdsListIndex = 1;
            for (String instanceIdsListValue : instanceIdsList) {
                if (instanceIdsListValue != null) {
                    request.addParameter("InstanceIds.member." + instanceIdsListIndex, StringUtils.fromString(instanceIdsListValue));
                }
                ++instanceIdsListIndex;
            }
        }
        if (detachInstancesRequest.getAutoScalingGroupName() != null) {
            request.addParameter("AutoScalingGroupName", StringUtils.fromString(detachInstancesRequest.getAutoScalingGroupName()));
        }
        if (detachInstancesRequest.getShouldDecrementDesiredCapacity() != null) {
            request.addParameter("ShouldDecrementDesiredCapacity", StringUtils.fromBoolean(detachInstancesRequest.getShouldDecrementDesiredCapacity()));
        }
        return request;
    }
}

