/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.apigateway.model;

import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.protocol.StructuredPojo;
import com.amazonaws.services.apigateway.model.transform.DeploymentCanarySettingsMarshaller;
import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;

public class DeploymentCanarySettings
implements Serializable,
Cloneable,
StructuredPojo {
    private Double percentTraffic;
    private Map<String, String> stageVariableOverrides;
    private Boolean useStageCache;

    public void setPercentTraffic(Double percentTraffic) {
        this.percentTraffic = percentTraffic;
    }

    public Double getPercentTraffic() {
        return this.percentTraffic;
    }

    public DeploymentCanarySettings withPercentTraffic(Double percentTraffic) {
        this.setPercentTraffic(percentTraffic);
        return this;
    }

    public Map<String, String> getStageVariableOverrides() {
        return this.stageVariableOverrides;
    }

    public void setStageVariableOverrides(Map<String, String> stageVariableOverrides) {
        this.stageVariableOverrides = stageVariableOverrides;
    }

    public DeploymentCanarySettings withStageVariableOverrides(Map<String, String> stageVariableOverrides) {
        this.setStageVariableOverrides(stageVariableOverrides);
        return this;
    }

    public DeploymentCanarySettings addStageVariableOverridesEntry(String key, String value) {
        if (null == this.stageVariableOverrides) {
            this.stageVariableOverrides = new HashMap<String, String>();
        }
        if (this.stageVariableOverrides.containsKey(key)) {
            throw new IllegalArgumentException("Duplicated keys (" + key.toString() + ") are provided.");
        }
        this.stageVariableOverrides.put(key, value);
        return this;
    }

    public DeploymentCanarySettings clearStageVariableOverridesEntries() {
        this.stageVariableOverrides = null;
        return this;
    }

    public void setUseStageCache(Boolean useStageCache) {
        this.useStageCache = useStageCache;
    }

    public Boolean getUseStageCache() {
        return this.useStageCache;
    }

    public DeploymentCanarySettings withUseStageCache(Boolean useStageCache) {
        this.setUseStageCache(useStageCache);
        return this;
    }

    public Boolean isUseStageCache() {
        return this.useStageCache;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getPercentTraffic() != null) {
            sb.append("PercentTraffic: ").append(this.getPercentTraffic()).append(",");
        }
        if (this.getStageVariableOverrides() != null) {
            sb.append("StageVariableOverrides: ").append(this.getStageVariableOverrides()).append(",");
        }
        if (this.getUseStageCache() != null) {
            sb.append("UseStageCache: ").append(this.getUseStageCache());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DeploymentCanarySettings)) {
            return false;
        }
        DeploymentCanarySettings other = (DeploymentCanarySettings)obj;
        if (other.getPercentTraffic() == null ^ this.getPercentTraffic() == null) {
            return false;
        }
        if (other.getPercentTraffic() != null && !other.getPercentTraffic().equals(this.getPercentTraffic())) {
            return false;
        }
        if (other.getStageVariableOverrides() == null ^ this.getStageVariableOverrides() == null) {
            return false;
        }
        if (other.getStageVariableOverrides() != null && !other.getStageVariableOverrides().equals(this.getStageVariableOverrides())) {
            return false;
        }
        if (other.getUseStageCache() == null ^ this.getUseStageCache() == null) {
            return false;
        }
        return other.getUseStageCache() == null || other.getUseStageCache().equals(this.getUseStageCache());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getPercentTraffic() == null ? 0 : this.getPercentTraffic().hashCode());
        hashCode = 31 * hashCode + (this.getStageVariableOverrides() == null ? 0 : this.getStageVariableOverrides().hashCode());
        hashCode = 31 * hashCode + (this.getUseStageCache() == null ? 0 : this.getUseStageCache().hashCode());
        return hashCode;
    }

    public DeploymentCanarySettings clone() {
        try {
            return (DeploymentCanarySettings)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }

    @Override
    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        DeploymentCanarySettingsMarshaller.getInstance().marshall(this, protocolMarshaller);
    }
}

