/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.alexaforbusiness.model.transform;

import com.amazonaws.SdkClientException;
import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.MarshallLocation;
import com.amazonaws.protocol.MarshallingInfo;
import com.amazonaws.protocol.MarshallingType;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.services.alexaforbusiness.model.AddressBookData;

@SdkInternalApi
public class AddressBookDataMarshaller {
    private static final MarshallingInfo<String> ADDRESSBOOKARN_BINDING = MarshallingInfo.builder(MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("AddressBookArn").build();
    private static final MarshallingInfo<String> NAME_BINDING = MarshallingInfo.builder(MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Name").build();
    private static final MarshallingInfo<String> DESCRIPTION_BINDING = MarshallingInfo.builder(MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Description").build();
    private static final AddressBookDataMarshaller instance = new AddressBookDataMarshaller();

    public static AddressBookDataMarshaller getInstance() {
        return instance;
    }

    public void marshall(AddressBookData addressBookData, ProtocolMarshaller protocolMarshaller) {
        if (addressBookData == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        try {
            protocolMarshaller.marshall(addressBookData.getAddressBookArn(), ADDRESSBOOKARN_BINDING);
            protocolMarshaller.marshall(addressBookData.getName(), NAME_BINDING);
            protocolMarshaller.marshall(addressBookData.getDescription(), DESCRIPTION_BINDING);
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), e);
        }
    }
}

