/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.elasticloadbalancingv2.model.transform;

import com.amazonaws.AmazonClientException;
import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.http.HttpMethodName;
import com.amazonaws.services.elasticloadbalancingv2.model.DescribeRulesRequest;
import com.amazonaws.transform.Marshaller;
import com.amazonaws.util.StringUtils;
import java.util.List;

public class DescribeRulesRequestMarshaller
implements Marshaller<Request<DescribeRulesRequest>, DescribeRulesRequest> {
    @Override
    public Request<DescribeRulesRequest> marshall(DescribeRulesRequest describeRulesRequest) {
        List<String> ruleArnsList;
        if (describeRulesRequest == null) {
            throw new AmazonClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest<DescribeRulesRequest> request = new DefaultRequest<DescribeRulesRequest>(describeRulesRequest, "AmazonElasticLoadBalancing");
        request.addParameter("Action", "DescribeRules");
        request.addParameter("Version", "2015-12-01");
        request.setHttpMethod(HttpMethodName.POST);
        if (describeRulesRequest.getListenerArn() != null) {
            request.addParameter("ListenerArn", StringUtils.fromString(describeRulesRequest.getListenerArn()));
        }
        if ((ruleArnsList = describeRulesRequest.getRuleArns()) != null) {
            if (ruleArnsList.isEmpty()) {
                request.addParameter("RuleArns", "");
            } else {
                int ruleArnsListIndex = 1;
                for (String ruleArnsListValue : ruleArnsList) {
                    if (ruleArnsListValue != null) {
                        request.addParameter("RuleArns.member." + ruleArnsListIndex, StringUtils.fromString(ruleArnsListValue));
                    }
                    ++ruleArnsListIndex;
                }
            }
        }
        return request;
    }
}

