/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.medialive.model;

import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.protocol.StructuredPojo;
import com.amazonaws.services.medialive.model.InputCodec;
import com.amazonaws.services.medialive.model.InputMaximumBitrate;
import com.amazonaws.services.medialive.model.InputResolution;
import com.amazonaws.services.medialive.model.transform.InputSpecificationMarshaller;
import java.io.Serializable;

public class InputSpecification
implements Serializable,
Cloneable,
StructuredPojo {
    private String codec;
    private String maximumBitrate;
    private String resolution;

    public void setCodec(String codec) {
        this.codec = codec;
    }

    public String getCodec() {
        return this.codec;
    }

    public InputSpecification withCodec(String codec) {
        this.setCodec(codec);
        return this;
    }

    public InputSpecification withCodec(InputCodec codec) {
        this.codec = codec.toString();
        return this;
    }

    public void setMaximumBitrate(String maximumBitrate) {
        this.maximumBitrate = maximumBitrate;
    }

    public String getMaximumBitrate() {
        return this.maximumBitrate;
    }

    public InputSpecification withMaximumBitrate(String maximumBitrate) {
        this.setMaximumBitrate(maximumBitrate);
        return this;
    }

    public InputSpecification withMaximumBitrate(InputMaximumBitrate maximumBitrate) {
        this.maximumBitrate = maximumBitrate.toString();
        return this;
    }

    public void setResolution(String resolution) {
        this.resolution = resolution;
    }

    public String getResolution() {
        return this.resolution;
    }

    public InputSpecification withResolution(String resolution) {
        this.setResolution(resolution);
        return this;
    }

    public InputSpecification withResolution(InputResolution resolution) {
        this.resolution = resolution.toString();
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getCodec() != null) {
            sb.append("Codec: ").append(this.getCodec()).append(",");
        }
        if (this.getMaximumBitrate() != null) {
            sb.append("MaximumBitrate: ").append(this.getMaximumBitrate()).append(",");
        }
        if (this.getResolution() != null) {
            sb.append("Resolution: ").append(this.getResolution());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof InputSpecification)) {
            return false;
        }
        InputSpecification other = (InputSpecification)obj;
        if (other.getCodec() == null ^ this.getCodec() == null) {
            return false;
        }
        if (other.getCodec() != null && !other.getCodec().equals(this.getCodec())) {
            return false;
        }
        if (other.getMaximumBitrate() == null ^ this.getMaximumBitrate() == null) {
            return false;
        }
        if (other.getMaximumBitrate() != null && !other.getMaximumBitrate().equals(this.getMaximumBitrate())) {
            return false;
        }
        if (other.getResolution() == null ^ this.getResolution() == null) {
            return false;
        }
        return other.getResolution() == null || other.getResolution().equals(this.getResolution());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getCodec() == null ? 0 : this.getCodec().hashCode());
        hashCode = 31 * hashCode + (this.getMaximumBitrate() == null ? 0 : this.getMaximumBitrate().hashCode());
        hashCode = 31 * hashCode + (this.getResolution() == null ? 0 : this.getResolution().hashCode());
        return hashCode;
    }

    public InputSpecification clone() {
        try {
            return (InputSpecification)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }

    @Override
    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        InputSpecificationMarshaller.getInstance().marshall(this, protocolMarshaller);
    }
}

