/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.iot.model;

import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.protocol.StructuredPojo;
import com.amazonaws.services.iot.model.StreamFile;
import com.amazonaws.services.iot.model.transform.StreamInfoMarshaller;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;

public class StreamInfo
implements Serializable,
Cloneable,
StructuredPojo {
    private String streamId;
    private String streamArn;
    private Integer streamVersion;
    private String description;
    private List<StreamFile> files;
    private Date createdAt;
    private Date lastUpdatedAt;
    private String roleArn;

    public void setStreamId(String streamId) {
        this.streamId = streamId;
    }

    public String getStreamId() {
        return this.streamId;
    }

    public StreamInfo withStreamId(String streamId) {
        this.setStreamId(streamId);
        return this;
    }

    public void setStreamArn(String streamArn) {
        this.streamArn = streamArn;
    }

    public String getStreamArn() {
        return this.streamArn;
    }

    public StreamInfo withStreamArn(String streamArn) {
        this.setStreamArn(streamArn);
        return this;
    }

    public void setStreamVersion(Integer streamVersion) {
        this.streamVersion = streamVersion;
    }

    public Integer getStreamVersion() {
        return this.streamVersion;
    }

    public StreamInfo withStreamVersion(Integer streamVersion) {
        this.setStreamVersion(streamVersion);
        return this;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public String getDescription() {
        return this.description;
    }

    public StreamInfo withDescription(String description) {
        this.setDescription(description);
        return this;
    }

    public List<StreamFile> getFiles() {
        return this.files;
    }

    public void setFiles(Collection<StreamFile> files) {
        if (files == null) {
            this.files = null;
            return;
        }
        this.files = new ArrayList<StreamFile>(files);
    }

    public StreamInfo withFiles(StreamFile ... files) {
        if (this.files == null) {
            this.setFiles(new ArrayList<StreamFile>(files.length));
        }
        for (StreamFile ele : files) {
            this.files.add(ele);
        }
        return this;
    }

    public StreamInfo withFiles(Collection<StreamFile> files) {
        this.setFiles(files);
        return this;
    }

    public void setCreatedAt(Date createdAt) {
        this.createdAt = createdAt;
    }

    public Date getCreatedAt() {
        return this.createdAt;
    }

    public StreamInfo withCreatedAt(Date createdAt) {
        this.setCreatedAt(createdAt);
        return this;
    }

    public void setLastUpdatedAt(Date lastUpdatedAt) {
        this.lastUpdatedAt = lastUpdatedAt;
    }

    public Date getLastUpdatedAt() {
        return this.lastUpdatedAt;
    }

    public StreamInfo withLastUpdatedAt(Date lastUpdatedAt) {
        this.setLastUpdatedAt(lastUpdatedAt);
        return this;
    }

    public void setRoleArn(String roleArn) {
        this.roleArn = roleArn;
    }

    public String getRoleArn() {
        return this.roleArn;
    }

    public StreamInfo withRoleArn(String roleArn) {
        this.setRoleArn(roleArn);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getStreamId() != null) {
            sb.append("StreamId: ").append(this.getStreamId()).append(",");
        }
        if (this.getStreamArn() != null) {
            sb.append("StreamArn: ").append(this.getStreamArn()).append(",");
        }
        if (this.getStreamVersion() != null) {
            sb.append("StreamVersion: ").append(this.getStreamVersion()).append(",");
        }
        if (this.getDescription() != null) {
            sb.append("Description: ").append(this.getDescription()).append(",");
        }
        if (this.getFiles() != null) {
            sb.append("Files: ").append(this.getFiles()).append(",");
        }
        if (this.getCreatedAt() != null) {
            sb.append("CreatedAt: ").append(this.getCreatedAt()).append(",");
        }
        if (this.getLastUpdatedAt() != null) {
            sb.append("LastUpdatedAt: ").append(this.getLastUpdatedAt()).append(",");
        }
        if (this.getRoleArn() != null) {
            sb.append("RoleArn: ").append(this.getRoleArn());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof StreamInfo)) {
            return false;
        }
        StreamInfo other = (StreamInfo)obj;
        if (other.getStreamId() == null ^ this.getStreamId() == null) {
            return false;
        }
        if (other.getStreamId() != null && !other.getStreamId().equals(this.getStreamId())) {
            return false;
        }
        if (other.getStreamArn() == null ^ this.getStreamArn() == null) {
            return false;
        }
        if (other.getStreamArn() != null && !other.getStreamArn().equals(this.getStreamArn())) {
            return false;
        }
        if (other.getStreamVersion() == null ^ this.getStreamVersion() == null) {
            return false;
        }
        if (other.getStreamVersion() != null && !other.getStreamVersion().equals(this.getStreamVersion())) {
            return false;
        }
        if (other.getDescription() == null ^ this.getDescription() == null) {
            return false;
        }
        if (other.getDescription() != null && !other.getDescription().equals(this.getDescription())) {
            return false;
        }
        if (other.getFiles() == null ^ this.getFiles() == null) {
            return false;
        }
        if (other.getFiles() != null && !other.getFiles().equals(this.getFiles())) {
            return false;
        }
        if (other.getCreatedAt() == null ^ this.getCreatedAt() == null) {
            return false;
        }
        if (other.getCreatedAt() != null && !other.getCreatedAt().equals(this.getCreatedAt())) {
            return false;
        }
        if (other.getLastUpdatedAt() == null ^ this.getLastUpdatedAt() == null) {
            return false;
        }
        if (other.getLastUpdatedAt() != null && !other.getLastUpdatedAt().equals(this.getLastUpdatedAt())) {
            return false;
        }
        if (other.getRoleArn() == null ^ this.getRoleArn() == null) {
            return false;
        }
        return other.getRoleArn() == null || other.getRoleArn().equals(this.getRoleArn());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getStreamId() == null ? 0 : this.getStreamId().hashCode());
        hashCode = 31 * hashCode + (this.getStreamArn() == null ? 0 : this.getStreamArn().hashCode());
        hashCode = 31 * hashCode + (this.getStreamVersion() == null ? 0 : this.getStreamVersion().hashCode());
        hashCode = 31 * hashCode + (this.getDescription() == null ? 0 : this.getDescription().hashCode());
        hashCode = 31 * hashCode + (this.getFiles() == null ? 0 : this.getFiles().hashCode());
        hashCode = 31 * hashCode + (this.getCreatedAt() == null ? 0 : this.getCreatedAt().hashCode());
        hashCode = 31 * hashCode + (this.getLastUpdatedAt() == null ? 0 : this.getLastUpdatedAt().hashCode());
        hashCode = 31 * hashCode + (this.getRoleArn() == null ? 0 : this.getRoleArn().hashCode());
        return hashCode;
    }

    public StreamInfo clone() {
        try {
            return (StreamInfo)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }

    @Override
    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        StreamInfoMarshaller.getInstance().marshall(this, protocolMarshaller);
    }
}

