/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.ecs.model.transform;

import com.amazonaws.SdkClientException;
import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.MarshallLocation;
import com.amazonaws.protocol.MarshallingInfo;
import com.amazonaws.protocol.MarshallingType;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.services.ecs.model.ContainerOverride;
import java.util.List;

@SdkInternalApi
public class ContainerOverrideMarshaller {
    private static final MarshallingInfo<String> NAME_BINDING = MarshallingInfo.builder(MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("name").build();
    private static final MarshallingInfo<List> COMMAND_BINDING = MarshallingInfo.builder(MarshallingType.LIST).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("command").build();
    private static final MarshallingInfo<List> ENVIRONMENT_BINDING = MarshallingInfo.builder(MarshallingType.LIST).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("environment").build();
    private static final MarshallingInfo<Integer> CPU_BINDING = MarshallingInfo.builder(MarshallingType.INTEGER).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("cpu").build();
    private static final MarshallingInfo<Integer> MEMORY_BINDING = MarshallingInfo.builder(MarshallingType.INTEGER).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("memory").build();
    private static final MarshallingInfo<Integer> MEMORYRESERVATION_BINDING = MarshallingInfo.builder(MarshallingType.INTEGER).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("memoryReservation").build();
    private static final ContainerOverrideMarshaller instance = new ContainerOverrideMarshaller();

    public static ContainerOverrideMarshaller getInstance() {
        return instance;
    }

    public void marshall(ContainerOverride containerOverride, ProtocolMarshaller protocolMarshaller) {
        if (containerOverride == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        try {
            protocolMarshaller.marshall(containerOverride.getName(), NAME_BINDING);
            protocolMarshaller.marshall(containerOverride.getCommand(), COMMAND_BINDING);
            protocolMarshaller.marshall(containerOverride.getEnvironment(), ENVIRONMENT_BINDING);
            protocolMarshaller.marshall(containerOverride.getCpu(), CPU_BINDING);
            protocolMarshaller.marshall(containerOverride.getMemory(), MEMORY_BINDING);
            protocolMarshaller.marshall(containerOverride.getMemoryReservation(), MEMORYRESERVATION_BINDING);
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), e);
        }
    }
}

