/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.ec2.model.transform;

import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.SdkClientException;
import com.amazonaws.http.HttpMethodName;
import com.amazonaws.internal.SdkInternalList;
import com.amazonaws.services.ec2.model.DescribeInstanceCreditSpecificationsRequest;
import com.amazonaws.services.ec2.model.Filter;
import com.amazonaws.transform.Marshaller;
import com.amazonaws.util.StringUtils;

public class DescribeInstanceCreditSpecificationsRequestMarshaller
implements Marshaller<Request<DescribeInstanceCreditSpecificationsRequest>, DescribeInstanceCreditSpecificationsRequest> {
    @Override
    public Request<DescribeInstanceCreditSpecificationsRequest> marshall(DescribeInstanceCreditSpecificationsRequest describeInstanceCreditSpecificationsRequest) {
        SdkInternalList describeInstanceCreditSpecificationsRequestInstanceIdsList;
        if (describeInstanceCreditSpecificationsRequest == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest<DescribeInstanceCreditSpecificationsRequest> request = new DefaultRequest<DescribeInstanceCreditSpecificationsRequest>(describeInstanceCreditSpecificationsRequest, "AmazonEC2");
        request.addParameter("Action", "DescribeInstanceCreditSpecifications");
        request.addParameter("Version", "2016-11-15");
        request.setHttpMethod(HttpMethodName.POST);
        SdkInternalList describeInstanceCreditSpecificationsRequestFiltersList = (SdkInternalList)describeInstanceCreditSpecificationsRequest.getFilters();
        if (!describeInstanceCreditSpecificationsRequestFiltersList.isEmpty() || !describeInstanceCreditSpecificationsRequestFiltersList.isAutoConstruct()) {
            int filtersListIndex = 1;
            for (Filter describeInstanceCreditSpecificationsRequestFiltersListValue : describeInstanceCreditSpecificationsRequestFiltersList) {
                SdkInternalList filterValuesList;
                if (describeInstanceCreditSpecificationsRequestFiltersListValue.getName() != null) {
                    request.addParameter("Filter." + filtersListIndex + ".Name", StringUtils.fromString(describeInstanceCreditSpecificationsRequestFiltersListValue.getName()));
                }
                if (!(filterValuesList = (SdkInternalList)describeInstanceCreditSpecificationsRequestFiltersListValue.getValues()).isEmpty() || !filterValuesList.isAutoConstruct()) {
                    int valuesListIndex = 1;
                    for (String filterValuesListValue : filterValuesList) {
                        if (filterValuesListValue != null) {
                            request.addParameter("Filter." + filtersListIndex + ".Value." + valuesListIndex, StringUtils.fromString(filterValuesListValue));
                        }
                        ++valuesListIndex;
                    }
                }
                ++filtersListIndex;
            }
        }
        if (!(describeInstanceCreditSpecificationsRequestInstanceIdsList = (SdkInternalList)describeInstanceCreditSpecificationsRequest.getInstanceIds()).isEmpty() || !describeInstanceCreditSpecificationsRequestInstanceIdsList.isAutoConstruct()) {
            int instanceIdsListIndex = 1;
            for (String describeInstanceCreditSpecificationsRequestInstanceIdsListValue : describeInstanceCreditSpecificationsRequestInstanceIdsList) {
                if (describeInstanceCreditSpecificationsRequestInstanceIdsListValue != null) {
                    request.addParameter("InstanceId." + instanceIdsListIndex, StringUtils.fromString(describeInstanceCreditSpecificationsRequestInstanceIdsListValue));
                }
                ++instanceIdsListIndex;
            }
        }
        if (describeInstanceCreditSpecificationsRequest.getMaxResults() != null) {
            request.addParameter("MaxResults", StringUtils.fromInteger(describeInstanceCreditSpecificationsRequest.getMaxResults()));
        }
        if (describeInstanceCreditSpecificationsRequest.getNextToken() != null) {
            request.addParameter("NextToken", StringUtils.fromString(describeInstanceCreditSpecificationsRequest.getNextToken()));
        }
        return request;
    }
}

