/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.translate;

import com.amazonaws.annotation.ThreadSafe;
import com.amazonaws.client.AwsAsyncClientParams;
import com.amazonaws.handlers.AsyncHandler;
import com.amazonaws.services.translate.AmazonTranslateAsync;
import com.amazonaws.services.translate.AmazonTranslateAsyncClientBuilder;
import com.amazonaws.services.translate.AmazonTranslateClient;
import com.amazonaws.services.translate.model.TranslateTextRequest;
import com.amazonaws.services.translate.model.TranslateTextResult;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;

@ThreadSafe
public class AmazonTranslateAsyncClient
extends AmazonTranslateClient
implements AmazonTranslateAsync {
    private static final int DEFAULT_THREAD_POOL_SIZE = 50;
    private final ExecutorService executorService;

    public static AmazonTranslateAsyncClientBuilder asyncBuilder() {
        return AmazonTranslateAsyncClientBuilder.standard();
    }

    AmazonTranslateAsyncClient(AwsAsyncClientParams asyncClientParams) {
        super(asyncClientParams);
        this.executorService = asyncClientParams.getExecutor();
    }

    public ExecutorService getExecutorService() {
        return this.executorService;
    }

    @Override
    public Future<TranslateTextResult> translateTextAsync(TranslateTextRequest request) {
        return this.translateTextAsync(request, null);
    }

    @Override
    public Future<TranslateTextResult> translateTextAsync(TranslateTextRequest request, final AsyncHandler<TranslateTextRequest, TranslateTextResult> asyncHandler) {
        final TranslateTextRequest finalRequest = this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<TranslateTextResult>(){

            @Override
            public TranslateTextResult call() throws Exception {
                TranslateTextResult result = null;
                try {
                    result = AmazonTranslateAsyncClient.this.executeTranslateText(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess(finalRequest, result);
                }
                return result;
            }
        });
    }

    @Override
    public void shutdown() {
        super.shutdown();
        this.executorService.shutdownNow();
    }
}

