/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.mediastoredata.model;

import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.protocol.StructuredPojo;
import com.amazonaws.services.mediastoredata.model.ItemType;
import com.amazonaws.services.mediastoredata.model.transform.ItemMarshaller;
import java.io.Serializable;
import java.util.Date;

public class Item
implements Serializable,
Cloneable,
StructuredPojo {
    private String name;
    private String type;
    private String eTag;
    private Date lastModified;
    private String contentType;
    private Long contentLength;

    public void setName(String name) {
        this.name = name;
    }

    public String getName() {
        return this.name;
    }

    public Item withName(String name) {
        this.setName(name);
        return this;
    }

    public void setType(String type) {
        this.type = type;
    }

    public String getType() {
        return this.type;
    }

    public Item withType(String type) {
        this.setType(type);
        return this;
    }

    public Item withType(ItemType type) {
        this.type = type.toString();
        return this;
    }

    public void setETag(String eTag) {
        this.eTag = eTag;
    }

    public String getETag() {
        return this.eTag;
    }

    public Item withETag(String eTag) {
        this.setETag(eTag);
        return this;
    }

    public void setLastModified(Date lastModified) {
        this.lastModified = lastModified;
    }

    public Date getLastModified() {
        return this.lastModified;
    }

    public Item withLastModified(Date lastModified) {
        this.setLastModified(lastModified);
        return this;
    }

    public void setContentType(String contentType) {
        this.contentType = contentType;
    }

    public String getContentType() {
        return this.contentType;
    }

    public Item withContentType(String contentType) {
        this.setContentType(contentType);
        return this;
    }

    public void setContentLength(Long contentLength) {
        this.contentLength = contentLength;
    }

    public Long getContentLength() {
        return this.contentLength;
    }

    public Item withContentLength(Long contentLength) {
        this.setContentLength(contentLength);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getName() != null) {
            sb.append("Name: ").append(this.getName()).append(",");
        }
        if (this.getType() != null) {
            sb.append("Type: ").append(this.getType()).append(",");
        }
        if (this.getETag() != null) {
            sb.append("ETag: ").append(this.getETag()).append(",");
        }
        if (this.getLastModified() != null) {
            sb.append("LastModified: ").append(this.getLastModified()).append(",");
        }
        if (this.getContentType() != null) {
            sb.append("ContentType: ").append(this.getContentType()).append(",");
        }
        if (this.getContentLength() != null) {
            sb.append("ContentLength: ").append(this.getContentLength());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Item)) {
            return false;
        }
        Item other = (Item)obj;
        if (other.getName() == null ^ this.getName() == null) {
            return false;
        }
        if (other.getName() != null && !other.getName().equals(this.getName())) {
            return false;
        }
        if (other.getType() == null ^ this.getType() == null) {
            return false;
        }
        if (other.getType() != null && !other.getType().equals(this.getType())) {
            return false;
        }
        if (other.getETag() == null ^ this.getETag() == null) {
            return false;
        }
        if (other.getETag() != null && !other.getETag().equals(this.getETag())) {
            return false;
        }
        if (other.getLastModified() == null ^ this.getLastModified() == null) {
            return false;
        }
        if (other.getLastModified() != null && !other.getLastModified().equals(this.getLastModified())) {
            return false;
        }
        if (other.getContentType() == null ^ this.getContentType() == null) {
            return false;
        }
        if (other.getContentType() != null && !other.getContentType().equals(this.getContentType())) {
            return false;
        }
        if (other.getContentLength() == null ^ this.getContentLength() == null) {
            return false;
        }
        return other.getContentLength() == null || other.getContentLength().equals(this.getContentLength());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getName() == null ? 0 : this.getName().hashCode());
        hashCode = 31 * hashCode + (this.getType() == null ? 0 : this.getType().hashCode());
        hashCode = 31 * hashCode + (this.getETag() == null ? 0 : this.getETag().hashCode());
        hashCode = 31 * hashCode + (this.getLastModified() == null ? 0 : this.getLastModified().hashCode());
        hashCode = 31 * hashCode + (this.getContentType() == null ? 0 : this.getContentType().hashCode());
        hashCode = 31 * hashCode + (this.getContentLength() == null ? 0 : this.getContentLength().hashCode());
        return hashCode;
    }

    public Item clone() {
        try {
            return (Item)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }

    @Override
    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        ItemMarshaller.getInstance().marshall(this, protocolMarshaller);
    }
}

