/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.iot.model.transform;

import com.amazonaws.SdkClientException;
import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.MarshallLocation;
import com.amazonaws.protocol.MarshallingInfo;
import com.amazonaws.protocol.MarshallingType;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.protocol.StructuredPojo;
import com.amazonaws.services.iot.model.CustomCodeSigning;

@SdkInternalApi
public class CustomCodeSigningMarshaller {
    private static final MarshallingInfo<StructuredPojo> SIGNATURE_BINDING = MarshallingInfo.builder(MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("signature").build();
    private static final MarshallingInfo<StructuredPojo> CERTIFICATECHAIN_BINDING = MarshallingInfo.builder(MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("certificateChain").build();
    private static final MarshallingInfo<String> HASHALGORITHM_BINDING = MarshallingInfo.builder(MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("hashAlgorithm").build();
    private static final MarshallingInfo<String> SIGNATUREALGORITHM_BINDING = MarshallingInfo.builder(MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("signatureAlgorithm").build();
    private static final CustomCodeSigningMarshaller instance = new CustomCodeSigningMarshaller();

    public static CustomCodeSigningMarshaller getInstance() {
        return instance;
    }

    public void marshall(CustomCodeSigning customCodeSigning, ProtocolMarshaller protocolMarshaller) {
        if (customCodeSigning == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        try {
            protocolMarshaller.marshall(customCodeSigning.getSignature(), SIGNATURE_BINDING);
            protocolMarshaller.marshall(customCodeSigning.getCertificateChain(), CERTIFICATECHAIN_BINDING);
            protocolMarshaller.marshall(customCodeSigning.getHashAlgorithm(), HASHALGORITHM_BINDING);
            protocolMarshaller.marshall(customCodeSigning.getSignatureAlgorithm(), SIGNATUREALGORITHM_BINDING);
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), e);
        }
    }
}

