/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.simpleemail.model;

import com.amazonaws.internal.SdkInternalList;
import com.amazonaws.services.simpleemail.model.Destination;
import com.amazonaws.services.simpleemail.model.MessageTag;
import java.io.Serializable;
import java.util.Collection;
import java.util.List;

public class BulkEmailDestination
implements Serializable,
Cloneable {
    private Destination destination;
    private SdkInternalList<MessageTag> replacementTags;
    private String replacementTemplateData;

    public void setDestination(Destination destination) {
        this.destination = destination;
    }

    public Destination getDestination() {
        return this.destination;
    }

    public BulkEmailDestination withDestination(Destination destination) {
        this.setDestination(destination);
        return this;
    }

    public List<MessageTag> getReplacementTags() {
        if (this.replacementTags == null) {
            this.replacementTags = new SdkInternalList();
        }
        return this.replacementTags;
    }

    public void setReplacementTags(Collection<MessageTag> replacementTags) {
        if (replacementTags == null) {
            this.replacementTags = null;
            return;
        }
        this.replacementTags = new SdkInternalList<MessageTag>(replacementTags);
    }

    public BulkEmailDestination withReplacementTags(MessageTag ... replacementTags) {
        if (this.replacementTags == null) {
            this.setReplacementTags(new SdkInternalList<MessageTag>(replacementTags.length));
        }
        for (MessageTag ele : replacementTags) {
            this.replacementTags.add(ele);
        }
        return this;
    }

    public BulkEmailDestination withReplacementTags(Collection<MessageTag> replacementTags) {
        this.setReplacementTags(replacementTags);
        return this;
    }

    public void setReplacementTemplateData(String replacementTemplateData) {
        this.replacementTemplateData = replacementTemplateData;
    }

    public String getReplacementTemplateData() {
        return this.replacementTemplateData;
    }

    public BulkEmailDestination withReplacementTemplateData(String replacementTemplateData) {
        this.setReplacementTemplateData(replacementTemplateData);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getDestination() != null) {
            sb.append("Destination: ").append(this.getDestination()).append(",");
        }
        if (this.getReplacementTags() != null) {
            sb.append("ReplacementTags: ").append(this.getReplacementTags()).append(",");
        }
        if (this.getReplacementTemplateData() != null) {
            sb.append("ReplacementTemplateData: ").append(this.getReplacementTemplateData());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof BulkEmailDestination)) {
            return false;
        }
        BulkEmailDestination other = (BulkEmailDestination)obj;
        if (other.getDestination() == null ^ this.getDestination() == null) {
            return false;
        }
        if (other.getDestination() != null && !other.getDestination().equals(this.getDestination())) {
            return false;
        }
        if (other.getReplacementTags() == null ^ this.getReplacementTags() == null) {
            return false;
        }
        if (other.getReplacementTags() != null && !other.getReplacementTags().equals(this.getReplacementTags())) {
            return false;
        }
        if (other.getReplacementTemplateData() == null ^ this.getReplacementTemplateData() == null) {
            return false;
        }
        return other.getReplacementTemplateData() == null || other.getReplacementTemplateData().equals(this.getReplacementTemplateData());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getDestination() == null ? 0 : this.getDestination().hashCode());
        hashCode = 31 * hashCode + (this.getReplacementTags() == null ? 0 : this.getReplacementTags().hashCode());
        hashCode = 31 * hashCode + (this.getReplacementTemplateData() == null ? 0 : this.getReplacementTemplateData().hashCode());
        return hashCode;
    }

    public BulkEmailDestination clone() {
        try {
            return (BulkEmailDestination)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }
}

