/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.pinpoint.model;

import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.protocol.StructuredPojo;
import com.amazonaws.services.pinpoint.model.MessageType;
import com.amazonaws.services.pinpoint.model.transform.SMSMessageMarshaller;
import java.io.Serializable;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class SMSMessage
implements Serializable,
Cloneable,
StructuredPojo {
    private String body;
    private String messageType;
    private String senderId;
    private Map<String, List<String>> substitutions;

    public void setBody(String body) {
        this.body = body;
    }

    public String getBody() {
        return this.body;
    }

    public SMSMessage withBody(String body) {
        this.setBody(body);
        return this;
    }

    public void setMessageType(String messageType) {
        this.messageType = messageType;
    }

    public String getMessageType() {
        return this.messageType;
    }

    public SMSMessage withMessageType(String messageType) {
        this.setMessageType(messageType);
        return this;
    }

    public void setMessageType(MessageType messageType) {
        this.withMessageType(messageType);
    }

    public SMSMessage withMessageType(MessageType messageType) {
        this.messageType = messageType.toString();
        return this;
    }

    public void setSenderId(String senderId) {
        this.senderId = senderId;
    }

    public String getSenderId() {
        return this.senderId;
    }

    public SMSMessage withSenderId(String senderId) {
        this.setSenderId(senderId);
        return this;
    }

    public Map<String, List<String>> getSubstitutions() {
        return this.substitutions;
    }

    public void setSubstitutions(Map<String, List<String>> substitutions) {
        this.substitutions = substitutions;
    }

    public SMSMessage withSubstitutions(Map<String, List<String>> substitutions) {
        this.setSubstitutions(substitutions);
        return this;
    }

    public SMSMessage addSubstitutionsEntry(String key, List<String> value) {
        if (null == this.substitutions) {
            this.substitutions = new HashMap<String, List<String>>();
        }
        if (this.substitutions.containsKey(key)) {
            throw new IllegalArgumentException("Duplicated keys (" + key.toString() + ") are provided.");
        }
        this.substitutions.put(key, value);
        return this;
    }

    public SMSMessage clearSubstitutionsEntries() {
        this.substitutions = null;
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getBody() != null) {
            sb.append("Body: ").append(this.getBody()).append(",");
        }
        if (this.getMessageType() != null) {
            sb.append("MessageType: ").append(this.getMessageType()).append(",");
        }
        if (this.getSenderId() != null) {
            sb.append("SenderId: ").append(this.getSenderId()).append(",");
        }
        if (this.getSubstitutions() != null) {
            sb.append("Substitutions: ").append(this.getSubstitutions());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof SMSMessage)) {
            return false;
        }
        SMSMessage other = (SMSMessage)obj;
        if (other.getBody() == null ^ this.getBody() == null) {
            return false;
        }
        if (other.getBody() != null && !other.getBody().equals(this.getBody())) {
            return false;
        }
        if (other.getMessageType() == null ^ this.getMessageType() == null) {
            return false;
        }
        if (other.getMessageType() != null && !other.getMessageType().equals(this.getMessageType())) {
            return false;
        }
        if (other.getSenderId() == null ^ this.getSenderId() == null) {
            return false;
        }
        if (other.getSenderId() != null && !other.getSenderId().equals(this.getSenderId())) {
            return false;
        }
        if (other.getSubstitutions() == null ^ this.getSubstitutions() == null) {
            return false;
        }
        return other.getSubstitutions() == null || other.getSubstitutions().equals(this.getSubstitutions());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getBody() == null ? 0 : this.getBody().hashCode());
        hashCode = 31 * hashCode + (this.getMessageType() == null ? 0 : this.getMessageType().hashCode());
        hashCode = 31 * hashCode + (this.getSenderId() == null ? 0 : this.getSenderId().hashCode());
        hashCode = 31 * hashCode + (this.getSubstitutions() == null ? 0 : this.getSubstitutions().hashCode());
        return hashCode;
    }

    public SMSMessage clone() {
        try {
            return (SMSMessage)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }

    @Override
    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        SMSMessageMarshaller.getInstance().marshall(this, protocolMarshaller);
    }
}

