/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.directory.model.transform;

import com.amazonaws.AmazonClientException;
import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.http.HttpMethodName;
import com.amazonaws.internal.SdkInternalList;
import com.amazonaws.protocol.json.SdkJsonProtocolFactory;
import com.amazonaws.protocol.json.StructuredJsonGenerator;
import com.amazonaws.services.directory.model.DescribeEventTopicsRequest;
import com.amazonaws.transform.Marshaller;
import java.io.ByteArrayInputStream;

public class DescribeEventTopicsRequestMarshaller
implements Marshaller<Request<DescribeEventTopicsRequest>, DescribeEventTopicsRequest> {
    private final SdkJsonProtocolFactory protocolFactory;

    public DescribeEventTopicsRequestMarshaller(SdkJsonProtocolFactory protocolFactory) {
        this.protocolFactory = protocolFactory;
    }

    @Override
    public Request<DescribeEventTopicsRequest> marshall(DescribeEventTopicsRequest describeEventTopicsRequest) {
        if (describeEventTopicsRequest == null) {
            throw new AmazonClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest<DescribeEventTopicsRequest> request = new DefaultRequest<DescribeEventTopicsRequest>(describeEventTopicsRequest, "AWSDirectoryService");
        request.addHeader("X-Amz-Target", "DirectoryService_20150416.DescribeEventTopics");
        request.setHttpMethod(HttpMethodName.POST);
        request.setResourcePath("");
        try {
            SdkInternalList topicNamesList;
            StructuredJsonGenerator jsonGenerator = this.protocolFactory.createGenerator();
            jsonGenerator.writeStartObject();
            if (describeEventTopicsRequest.getDirectoryId() != null) {
                jsonGenerator.writeFieldName("DirectoryId").writeValue(describeEventTopicsRequest.getDirectoryId());
            }
            if (!(topicNamesList = (SdkInternalList)describeEventTopicsRequest.getTopicNames()).isEmpty() || !topicNamesList.isAutoConstruct()) {
                jsonGenerator.writeFieldName("TopicNames");
                jsonGenerator.writeStartArray();
                for (String topicNamesListValue : topicNamesList) {
                    if (topicNamesListValue == null) continue;
                    jsonGenerator.writeValue(topicNamesListValue);
                }
                jsonGenerator.writeEndArray();
            }
            jsonGenerator.writeEndObject();
            byte[] content = jsonGenerator.getBytes();
            request.setContent(new ByteArrayInputStream(content));
            request.addHeader("Content-Length", Integer.toString(content.length));
            request.addHeader("Content-Type", this.protocolFactory.getContentType());
        }
        catch (Throwable t) {
            throw new AmazonClientException("Unable to marshall request to JSON: " + t.getMessage(), t);
        }
        return request;
    }
}

