/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.simpleemail.model.transform;

import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.SdkClientException;
import com.amazonaws.http.HttpMethodName;
import com.amazonaws.internal.SdkInternalList;
import com.amazonaws.services.simpleemail.model.CloudWatchDestination;
import com.amazonaws.services.simpleemail.model.CloudWatchDimensionConfiguration;
import com.amazonaws.services.simpleemail.model.EventDestination;
import com.amazonaws.services.simpleemail.model.KinesisFirehoseDestination;
import com.amazonaws.services.simpleemail.model.SNSDestination;
import com.amazonaws.services.simpleemail.model.UpdateConfigurationSetEventDestinationRequest;
import com.amazonaws.transform.Marshaller;
import com.amazonaws.util.StringUtils;

public class UpdateConfigurationSetEventDestinationRequestMarshaller
implements Marshaller<Request<UpdateConfigurationSetEventDestinationRequest>, UpdateConfigurationSetEventDestinationRequest> {
    @Override
    public Request<UpdateConfigurationSetEventDestinationRequest> marshall(UpdateConfigurationSetEventDestinationRequest updateConfigurationSetEventDestinationRequest) {
        EventDestination eventDestination;
        if (updateConfigurationSetEventDestinationRequest == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest<UpdateConfigurationSetEventDestinationRequest> request = new DefaultRequest<UpdateConfigurationSetEventDestinationRequest>(updateConfigurationSetEventDestinationRequest, "AmazonSimpleEmailService");
        request.addParameter("Action", "UpdateConfigurationSetEventDestination");
        request.addParameter("Version", "2010-12-01");
        request.setHttpMethod(HttpMethodName.POST);
        if (updateConfigurationSetEventDestinationRequest.getConfigurationSetName() != null) {
            request.addParameter("ConfigurationSetName", StringUtils.fromString(updateConfigurationSetEventDestinationRequest.getConfigurationSetName()));
        }
        if ((eventDestination = updateConfigurationSetEventDestinationRequest.getEventDestination()) != null) {
            SNSDestination sNSDestination;
            SdkInternalList dimensionConfigurationsList;
            CloudWatchDestination cloudWatchDestination;
            KinesisFirehoseDestination kinesisFirehoseDestination;
            SdkInternalList matchingEventTypesList;
            if (eventDestination.getName() != null) {
                request.addParameter("EventDestination.Name", StringUtils.fromString(eventDestination.getName()));
            }
            if (eventDestination.getEnabled() != null) {
                request.addParameter("EventDestination.Enabled", StringUtils.fromBoolean(eventDestination.getEnabled()));
            }
            if (!(matchingEventTypesList = (SdkInternalList)eventDestination.getMatchingEventTypes()).isEmpty() || !matchingEventTypesList.isAutoConstruct()) {
                int matchingEventTypesListIndex = 1;
                for (String matchingEventTypesListValue : matchingEventTypesList) {
                    if (matchingEventTypesListValue != null) {
                        request.addParameter("EventDestination.MatchingEventTypes.member." + matchingEventTypesListIndex, StringUtils.fromString(matchingEventTypesListValue));
                    }
                    ++matchingEventTypesListIndex;
                }
            }
            if ((kinesisFirehoseDestination = eventDestination.getKinesisFirehoseDestination()) != null) {
                if (kinesisFirehoseDestination.getIAMRoleARN() != null) {
                    request.addParameter("EventDestination.KinesisFirehoseDestination.IAMRoleARN", StringUtils.fromString(kinesisFirehoseDestination.getIAMRoleARN()));
                }
                if (kinesisFirehoseDestination.getDeliveryStreamARN() != null) {
                    request.addParameter("EventDestination.KinesisFirehoseDestination.DeliveryStreamARN", StringUtils.fromString(kinesisFirehoseDestination.getDeliveryStreamARN()));
                }
            }
            if (!((cloudWatchDestination = eventDestination.getCloudWatchDestination()) == null || (dimensionConfigurationsList = (SdkInternalList)cloudWatchDestination.getDimensionConfigurations()).isEmpty() && dimensionConfigurationsList.isAutoConstruct())) {
                int dimensionConfigurationsListIndex = 1;
                for (CloudWatchDimensionConfiguration dimensionConfigurationsListValue : dimensionConfigurationsList) {
                    if (dimensionConfigurationsListValue.getDimensionName() != null) {
                        request.addParameter("EventDestination.CloudWatchDestination.DimensionConfigurations.member." + dimensionConfigurationsListIndex + ".DimensionName", StringUtils.fromString(dimensionConfigurationsListValue.getDimensionName()));
                    }
                    if (dimensionConfigurationsListValue.getDimensionValueSource() != null) {
                        request.addParameter("EventDestination.CloudWatchDestination.DimensionConfigurations.member." + dimensionConfigurationsListIndex + ".DimensionValueSource", StringUtils.fromString(dimensionConfigurationsListValue.getDimensionValueSource()));
                    }
                    if (dimensionConfigurationsListValue.getDefaultDimensionValue() != null) {
                        request.addParameter("EventDestination.CloudWatchDestination.DimensionConfigurations.member." + dimensionConfigurationsListIndex + ".DefaultDimensionValue", StringUtils.fromString(dimensionConfigurationsListValue.getDefaultDimensionValue()));
                    }
                    ++dimensionConfigurationsListIndex;
                }
            }
            if ((sNSDestination = eventDestination.getSNSDestination()) != null && sNSDestination.getTopicARN() != null) {
                request.addParameter("EventDestination.SNSDestination.TopicARN", StringUtils.fromString(sNSDestination.getTopicARN()));
            }
        }
        return request;
    }
}

