/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.rds.model.transform;

import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.SdkClientException;
import com.amazonaws.http.HttpMethodName;
import com.amazonaws.services.rds.model.StopDBInstanceRequest;
import com.amazonaws.transform.Marshaller;
import com.amazonaws.util.StringUtils;

public class StopDBInstanceRequestMarshaller
implements Marshaller<Request<StopDBInstanceRequest>, StopDBInstanceRequest> {
    @Override
    public Request<StopDBInstanceRequest> marshall(StopDBInstanceRequest stopDBInstanceRequest) {
        if (stopDBInstanceRequest == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest<StopDBInstanceRequest> request = new DefaultRequest<StopDBInstanceRequest>(stopDBInstanceRequest, "AmazonRDS");
        request.addParameter("Action", "StopDBInstance");
        request.addParameter("Version", "2014-10-31");
        request.setHttpMethod(HttpMethodName.POST);
        if (stopDBInstanceRequest.getDBInstanceIdentifier() != null) {
            request.addParameter("DBInstanceIdentifier", StringUtils.fromString(stopDBInstanceRequest.getDBInstanceIdentifier()));
        }
        if (stopDBInstanceRequest.getDBSnapshotIdentifier() != null) {
            request.addParameter("DBSnapshotIdentifier", StringUtils.fromString(stopDBInstanceRequest.getDBSnapshotIdentifier()));
        }
        return request;
    }
}

