/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.workdocs.model;

import com.amazonaws.AmazonWebServiceRequest;
import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;

public class CreateCustomMetadataRequest
extends AmazonWebServiceRequest
implements Serializable,
Cloneable {
    private String authenticationToken;
    private String resourceId;
    private String versionId;
    private Map<String, String> customMetadata;

    public void setAuthenticationToken(String authenticationToken) {
        this.authenticationToken = authenticationToken;
    }

    public String getAuthenticationToken() {
        return this.authenticationToken;
    }

    public CreateCustomMetadataRequest withAuthenticationToken(String authenticationToken) {
        this.setAuthenticationToken(authenticationToken);
        return this;
    }

    public void setResourceId(String resourceId) {
        this.resourceId = resourceId;
    }

    public String getResourceId() {
        return this.resourceId;
    }

    public CreateCustomMetadataRequest withResourceId(String resourceId) {
        this.setResourceId(resourceId);
        return this;
    }

    public void setVersionId(String versionId) {
        this.versionId = versionId;
    }

    public String getVersionId() {
        return this.versionId;
    }

    public CreateCustomMetadataRequest withVersionId(String versionId) {
        this.setVersionId(versionId);
        return this;
    }

    public Map<String, String> getCustomMetadata() {
        return this.customMetadata;
    }

    public void setCustomMetadata(Map<String, String> customMetadata) {
        this.customMetadata = customMetadata;
    }

    public CreateCustomMetadataRequest withCustomMetadata(Map<String, String> customMetadata) {
        this.setCustomMetadata(customMetadata);
        return this;
    }

    public CreateCustomMetadataRequest addCustomMetadataEntry(String key, String value) {
        if (null == this.customMetadata) {
            this.customMetadata = new HashMap<String, String>();
        }
        if (this.customMetadata.containsKey(key)) {
            throw new IllegalArgumentException("Duplicated keys (" + key.toString() + ") are provided.");
        }
        this.customMetadata.put(key, value);
        return this;
    }

    public CreateCustomMetadataRequest clearCustomMetadataEntries() {
        this.customMetadata = null;
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getAuthenticationToken() != null) {
            sb.append("AuthenticationToken: ").append(this.getAuthenticationToken()).append(",");
        }
        if (this.getResourceId() != null) {
            sb.append("ResourceId: ").append(this.getResourceId()).append(",");
        }
        if (this.getVersionId() != null) {
            sb.append("VersionId: ").append(this.getVersionId()).append(",");
        }
        if (this.getCustomMetadata() != null) {
            sb.append("CustomMetadata: ").append(this.getCustomMetadata());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateCustomMetadataRequest)) {
            return false;
        }
        CreateCustomMetadataRequest other = (CreateCustomMetadataRequest)obj;
        if (other.getAuthenticationToken() == null ^ this.getAuthenticationToken() == null) {
            return false;
        }
        if (other.getAuthenticationToken() != null && !other.getAuthenticationToken().equals(this.getAuthenticationToken())) {
            return false;
        }
        if (other.getResourceId() == null ^ this.getResourceId() == null) {
            return false;
        }
        if (other.getResourceId() != null && !other.getResourceId().equals(this.getResourceId())) {
            return false;
        }
        if (other.getVersionId() == null ^ this.getVersionId() == null) {
            return false;
        }
        if (other.getVersionId() != null && !other.getVersionId().equals(this.getVersionId())) {
            return false;
        }
        if (other.getCustomMetadata() == null ^ this.getCustomMetadata() == null) {
            return false;
        }
        return other.getCustomMetadata() == null || other.getCustomMetadata().equals(this.getCustomMetadata());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getAuthenticationToken() == null ? 0 : this.getAuthenticationToken().hashCode());
        hashCode = 31 * hashCode + (this.getResourceId() == null ? 0 : this.getResourceId().hashCode());
        hashCode = 31 * hashCode + (this.getVersionId() == null ? 0 : this.getVersionId().hashCode());
        hashCode = 31 * hashCode + (this.getCustomMetadata() == null ? 0 : this.getCustomMetadata().hashCode());
        return hashCode;
    }

    @Override
    public CreateCustomMetadataRequest clone() {
        return (CreateCustomMetadataRequest)super.clone();
    }
}

