/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.clouddirectory.model;

import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.protocol.StructuredPojo;
import com.amazonaws.services.clouddirectory.model.ObjectAttributeRange;
import com.amazonaws.services.clouddirectory.model.ObjectReference;
import com.amazonaws.services.clouddirectory.model.transform.BatchListIndexMarshaller;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class BatchListIndex
implements Serializable,
Cloneable,
StructuredPojo {
    private List<ObjectAttributeRange> rangesOnIndexedValues;
    private ObjectReference indexReference;
    private Integer maxResults;
    private String nextToken;

    public List<ObjectAttributeRange> getRangesOnIndexedValues() {
        return this.rangesOnIndexedValues;
    }

    public void setRangesOnIndexedValues(Collection<ObjectAttributeRange> rangesOnIndexedValues) {
        if (rangesOnIndexedValues == null) {
            this.rangesOnIndexedValues = null;
            return;
        }
        this.rangesOnIndexedValues = new ArrayList<ObjectAttributeRange>(rangesOnIndexedValues);
    }

    public BatchListIndex withRangesOnIndexedValues(ObjectAttributeRange ... rangesOnIndexedValues) {
        if (this.rangesOnIndexedValues == null) {
            this.setRangesOnIndexedValues(new ArrayList<ObjectAttributeRange>(rangesOnIndexedValues.length));
        }
        for (ObjectAttributeRange ele : rangesOnIndexedValues) {
            this.rangesOnIndexedValues.add(ele);
        }
        return this;
    }

    public BatchListIndex withRangesOnIndexedValues(Collection<ObjectAttributeRange> rangesOnIndexedValues) {
        this.setRangesOnIndexedValues(rangesOnIndexedValues);
        return this;
    }

    public void setIndexReference(ObjectReference indexReference) {
        this.indexReference = indexReference;
    }

    public ObjectReference getIndexReference() {
        return this.indexReference;
    }

    public BatchListIndex withIndexReference(ObjectReference indexReference) {
        this.setIndexReference(indexReference);
        return this;
    }

    public void setMaxResults(Integer maxResults) {
        this.maxResults = maxResults;
    }

    public Integer getMaxResults() {
        return this.maxResults;
    }

    public BatchListIndex withMaxResults(Integer maxResults) {
        this.setMaxResults(maxResults);
        return this;
    }

    public void setNextToken(String nextToken) {
        this.nextToken = nextToken;
    }

    public String getNextToken() {
        return this.nextToken;
    }

    public BatchListIndex withNextToken(String nextToken) {
        this.setNextToken(nextToken);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getRangesOnIndexedValues() != null) {
            sb.append("RangesOnIndexedValues: ").append(this.getRangesOnIndexedValues()).append(",");
        }
        if (this.getIndexReference() != null) {
            sb.append("IndexReference: ").append(this.getIndexReference()).append(",");
        }
        if (this.getMaxResults() != null) {
            sb.append("MaxResults: ").append(this.getMaxResults()).append(",");
        }
        if (this.getNextToken() != null) {
            sb.append("NextToken: ").append(this.getNextToken());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof BatchListIndex)) {
            return false;
        }
        BatchListIndex other = (BatchListIndex)obj;
        if (other.getRangesOnIndexedValues() == null ^ this.getRangesOnIndexedValues() == null) {
            return false;
        }
        if (other.getRangesOnIndexedValues() != null && !other.getRangesOnIndexedValues().equals(this.getRangesOnIndexedValues())) {
            return false;
        }
        if (other.getIndexReference() == null ^ this.getIndexReference() == null) {
            return false;
        }
        if (other.getIndexReference() != null && !other.getIndexReference().equals(this.getIndexReference())) {
            return false;
        }
        if (other.getMaxResults() == null ^ this.getMaxResults() == null) {
            return false;
        }
        if (other.getMaxResults() != null && !other.getMaxResults().equals(this.getMaxResults())) {
            return false;
        }
        if (other.getNextToken() == null ^ this.getNextToken() == null) {
            return false;
        }
        return other.getNextToken() == null || other.getNextToken().equals(this.getNextToken());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getRangesOnIndexedValues() == null ? 0 : this.getRangesOnIndexedValues().hashCode());
        hashCode = 31 * hashCode + (this.getIndexReference() == null ? 0 : this.getIndexReference().hashCode());
        hashCode = 31 * hashCode + (this.getMaxResults() == null ? 0 : this.getMaxResults().hashCode());
        hashCode = 31 * hashCode + (this.getNextToken() == null ? 0 : this.getNextToken().hashCode());
        return hashCode;
    }

    public BatchListIndex clone() {
        try {
            return (BatchListIndex)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }

    @Override
    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        BatchListIndexMarshaller.getInstance().marshall(this, protocolMarshaller);
    }
}

