/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.dynamodbv2.datamodeling;

import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.services.dynamodbv2.datamodeling.DynamoDBMappingException;
import com.amazonaws.services.dynamodbv2.datamodeling.DynamoDBTypeConverter;
import com.amazonaws.services.dynamodbv2.model.ScalarAttributeType;
import com.amazonaws.util.DateUtils;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collection;
import java.util.Date;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;

@SdkInternalApi
final class StandardTypeConverters
implements DynamoDBTypeConverter.Factory {
    private static final DynamoDBTypeConverter.Factory FACTORY = new StandardTypeConverters();

    StandardTypeConverters() {
    }

    static final DynamoDBTypeConverter.Factory factory() {
        return FACTORY;
    }

    @Override
    public <S, T> DynamoDBTypeConverter<S, T> getConverter(Class<T> targetType) {
        ScalarAttributeType scalarType = Scalar.of(targetType).scalarType;
        if (scalarType == ScalarAttributeType.B) {
            return Scalar.BYTE_BUFFER.getConverter(targetType);
        }
        if (scalarType != null) {
            return Scalar.STRING.getConverter(targetType);
        }
        return null;
    }

    static class ConvertTo<S, T> {
        private static final ConvertTo<?, ?> ANY = new ConvertTo();

        ConvertTo() {
        }

        public S convertTo(T o) {
            return (S)o;
        }
    }

    static class ConvertToMap<t, T>
    extends LinkedHashMap<Class<t>, T> {
        ConvertToMap() {
        }

        public ConvertToMap<t, T> with(Class<?> key, T value) {
            this.put(key, value);
            return this;
        }

        public T from(Class<?> key) {
            for (Map.Entry entry : this.entrySet()) {
                if (!((Class)entry.getKey()).isAssignableFrom(key)) continue;
                return (T)entry.getValue();
            }
            return null;
        }
    }

    static enum Vector {
        LIST((Class)List.class){

            @Override
            final <S, T> DynamoDBTypeConverter<S, T> wrap(final DynamoDBTypeConverter<S, T> scalar) {
                return new DynamoDBTypeConverter<Collection<S>, Collection<T>>(){

                    @Override
                    public final Collection<S> convert(Collection<T> o) {
                        return Vector.convert(o, scalar);
                    }

                    @Override
                    public final Collection<T> unconvert(Collection<S> o) {
                        return Vector.unconvert(o, scalar);
                    }
                };
            }
        }
        ,
        MAP((Class)Map.class){

            @Override
            final <S, T> DynamoDBTypeConverter<S, T> wrap(final DynamoDBTypeConverter<S, T> scalar) {
                return new DynamoDBTypeConverter<Map<Object, S>, Map<Object, T>>(){

                    @Override
                    public final Map<Object, S> convert(Map<Object, T> o) {
                        return Vector.convert(o, scalar);
                    }

                    @Override
                    public final Map<Object, T> unconvert(Map<Object, S> o) {
                        return Vector.unconvert(o, scalar);
                    }
                };
            }
        }
        ,
        SET((Class)Set.class){

            @Override
            final <S, T> DynamoDBTypeConverter<S, T> wrap(final DynamoDBTypeConverter<S, T> scalar) {
                return new DynamoDBTypeConverter<Collection<S>, Collection<T>>(){

                    @Override
                    public final Collection<S> convert(Collection<T> o) {
                        return Vector.convert(o, scalar);
                    }

                    @Override
                    public final Collection<T> unconvert(Collection<S> o) {
                        LinkedHashSet vector = new LinkedHashSet();
                        for (Object s : o) {
                            if (vector.add(scalar.unconvert(s))) continue;
                            throw new DynamoDBMappingException("duplicate value (" + s + ")");
                        }
                        return vector;
                    }
                };
            }
        };

        private final Class<?> type;

        abstract <S, T> DynamoDBTypeConverter<S, T> wrap(DynamoDBTypeConverter<S, T> var1);

        private Vector(Class<?> type) {
            this.type = type;
        }

        final boolean is(Class<?> sourceType) {
            return this.type.isAssignableFrom(sourceType);
        }

        static final <S, T> List<S> convert(Collection<T> o, DynamoDBTypeConverter<S, T> scalar) {
            ArrayList<S> vector = new ArrayList<S>(o.size());
            for (T t : o) {
                vector.add(scalar.convert(t));
            }
            return vector;
        }

        static final <S, T> List<T> unconvert(Collection<S> o, DynamoDBTypeConverter<S, T> scalar) {
            ArrayList<T> vector = new ArrayList<T>(o.size());
            for (S s : o) {
                vector.add(scalar.unconvert(s));
            }
            return vector;
        }

        static final <K, S, T> Map<K, S> convert(Map<K, T> o, DynamoDBTypeConverter<S, T> scalar) {
            LinkedHashMap<K, S> vector = new LinkedHashMap<K, S>();
            for (Map.Entry<K, T> t : o.entrySet()) {
                vector.put(t.getKey(), scalar.convert(t.getValue()));
            }
            return vector;
        }

        static final <K, S, T> Map<K, T> unconvert(Map<K, S> o, DynamoDBTypeConverter<S, T> scalar) {
            LinkedHashMap<K, T> vector = new LinkedHashMap<K, T>();
            for (Map.Entry<K, S> s : o.entrySet()) {
                vector.put(s.getKey(), scalar.unconvert(s.getValue()));
            }
            return vector;
        }
    }

    static enum Scalar implements DynamoDBTypeConverter.Factory
    {
        BIG_DECIMAL(BigDecimal.class, null, ScalarAttributeType.N, new ConvertToMap<t, 1>().with(String.class, new ConvertTo<BigDecimal, String>(){

            @Override
            public final BigDecimal convertTo(String o) {
                return new BigDecimal(o);
            }
        })),
        BIG_INTEGER(BigInteger.class, null, ScalarAttributeType.N, new ConvertToMap<t, 2>().with(String.class, new ConvertTo<BigInteger, String>(){

            @Override
            public final BigInteger convertTo(String o) {
                return new BigInteger(o);
            }
        })),
        BOOLEAN(Boolean.class, Boolean.TYPE, ScalarAttributeType.N, new ConvertToMap<t, 3>().with(String.class, new ConvertTo<Boolean, String>(){

            @Override
            public final Boolean convertTo(String o) {
                return "0".equals(o) ? Boolean.FALSE : ("1".equals(o) ? Boolean.TRUE : Boolean.valueOf(o));
            }
        })),
        BYTE(Byte.class, Byte.TYPE, ScalarAttributeType.N, new ConvertToMap<t, 4>().with(String.class, new ConvertTo<Byte, String>(){

            @Override
            public final Byte convertTo(String o) {
                return Byte.valueOf(o);
            }
        })),
        BYTE_ARRAY(byte[].class, null, ScalarAttributeType.B, new ConvertToMap<t, 5>().with(ByteBuffer.class, new ConvertTo<byte[], ByteBuffer>(){

            @Override
            public final byte[] convertTo(ByteBuffer o) {
                if (o.hasArray()) {
                    return o.array();
                }
                byte[] array = new byte[o.remaining()];
                o.get(array);
                return array;
            }
        })),
        BYTE_BUFFER(ByteBuffer.class, null, ScalarAttributeType.B, new ConvertToMap<t, 6>().with(byte[].class, new ConvertTo<ByteBuffer, byte[]>(){

            @Override
            public final ByteBuffer convertTo(byte[] o) {
                return ByteBuffer.wrap(o);
            }
        })),
        CALENDAR(Calendar.class, null, ScalarAttributeType.S, new ConvertToMap<t, 8>().with(Date.class, new ConvertTo<Calendar, Date>(){

            @Override
            public final Calendar convertTo(Date o) {
                Calendar calendar = Calendar.getInstance();
                calendar.setTime(o);
                return calendar;
            }
        }).with(String.class, new ConvertTo<Calendar, String>(){

            @Override
            public final Calendar convertTo(String o) {
                Calendar calendar = Calendar.getInstance();
                calendar.setTime(DateUtils.parseISO8601Date(o));
                return calendar;
            }
        })),
        CHARACTER(Character.class, Character.TYPE, ScalarAttributeType.S, new ConvertToMap<t, 9>().with(String.class, new ConvertTo<Character, String>(){

            @Override
            public final Character convertTo(String o) {
                if (o.length() != 1) {
                    throw new DynamoDBMappingException("expected single character string");
                }
                return Character.valueOf(o.charAt(0));
            }
        })),
        DATE(Date.class, null, ScalarAttributeType.S, new ConvertToMap<t, 12>().with(Calendar.class, new ConvertTo<Date, Calendar>(){

            @Override
            public final Date convertTo(Calendar o) {
                return o.getTime();
            }
        }).with(Long.class, new ConvertTo<Date, Long>(){

            @Override
            public final Date convertTo(Long o) {
                return new Date(o);
            }
        }).with(String.class, new ConvertTo<Date, String>(){

            @Override
            public final Date convertTo(String o) {
                return DateUtils.parseISO8601Date(o);
            }
        })),
        DOUBLE(Double.class, Double.TYPE, ScalarAttributeType.N, new ConvertToMap<t, 13>().with(String.class, new ConvertTo<Double, String>(){

            @Override
            public final Double convertTo(String o) {
                return Double.valueOf(o);
            }
        })),
        FLOAT(Float.class, Float.TYPE, ScalarAttributeType.N, new ConvertToMap<t, 14>().with(String.class, new ConvertTo<Float, String>(){

            @Override
            public final Float convertTo(String o) {
                return Float.valueOf(o);
            }
        })),
        INTEGER(Integer.class, Integer.TYPE, ScalarAttributeType.N, new ConvertToMap<t, 15>().with(String.class, new ConvertTo<Integer, String>(){

            @Override
            public final Integer convertTo(String o) {
                return Integer.valueOf(o);
            }
        })),
        LONG(Long.class, Long.TYPE, ScalarAttributeType.N, new ConvertToMap<t, 17>().with(Date.class, new ConvertTo<Long, Date>(){

            @Override
            public final Long convertTo(Date o) {
                return o.getTime();
            }
        }).with(String.class, new ConvertTo<Long, String>(){

            @Override
            public final Long convertTo(String o) {
                return Long.valueOf(o);
            }
        })),
        SHORT(Short.class, Short.TYPE, ScalarAttributeType.N, new ConvertToMap<t, 18>().with(String.class, new ConvertTo<Short, String>(){

            @Override
            public final Short convertTo(String o) {
                return Short.valueOf(o);
            }
        })),
        STRING(String.class, null, ScalarAttributeType.S, new ConvertToMap<t, 22>().with(Boolean.class, new ConvertTo<String, Boolean>(){

            @Override
            public final String convertTo(Boolean o) {
                return Boolean.TRUE.equals(o) ? "1" : "0";
            }
        }).with(Calendar.class, new ConvertTo<String, Calendar>(){

            @Override
            public final String convertTo(Calendar o) {
                return DateUtils.formatISO8601Date(o.getTime());
            }
        }).with(Date.class, new ConvertTo<String, Date>(){

            @Override
            public final String convertTo(Date o) {
                return DateUtils.formatISO8601Date(o);
            }
        }).with(Object.class, new ConvertTo<String, Object>(){

            @Override
            public final String convertTo(Object o) {
                return o.toString();
            }
        })),
        UUID(UUID.class, null, ScalarAttributeType.S, new ConvertToMap<t, 23>().with(String.class, new ConvertTo<UUID, String>(){

            @Override
            public final UUID convertTo(String o) {
                return java.util.UUID.fromString(o);
            }
        })),
        DEFAULT(Object.class, null, null, new ConvertToMap<t, T>());

        private final ConvertToMap<?, ConvertTo<?, ?>> map;
        private final Class<?> type;
        private final Class<?> primitiveType;
        private final ScalarAttributeType scalarType;

        private Scalar(Class<?> type, Class<?> primitiveType, ScalarAttributeType scalarType, ConvertToMap<?, ConvertTo<?, ?>> map) {
            this.type = type;
            this.primitiveType = primitiveType;
            this.scalarType = scalarType;
            this.map = map;
        }

        @Override
        public <S, T> DynamoDBTypeConverter<S, T> getConverter(final Class<T> targetType) {
            if (this == STRING && targetType.isEnum()) {
                return new DynamoDBTypeConverter<String, Enum>(){

                    @Override
                    public final String convert(Enum o) {
                        return o.name();
                    }

                    @Override
                    public final Enum unconvert(String o) {
                        return Enum.valueOf(targetType, o);
                    }
                };
            }
            Scalar source = this;
            Scalar target = Scalar.of(targetType);
            final ConvertTo<S, T> sourceFromTarget = source.from(targetType);
            final ConvertTo<S, ?> targetFromSource = target.from(this.type);
            return new DynamoDBTypeConverter<S, T>(){

                @Override
                public final S convert(T o) {
                    return sourceFromTarget.convertTo(o);
                }

                @Override
                public final T unconvert(S o) {
                    return targetFromSource.convertTo(o);
                }
            };
        }

        final <S, T> ConvertTo<S, T> from(Class<T> targetType) {
            ConvertTo converter = this.map.from(Scalar.of(targetType).type);
            if (converter == null) {
                if (!this.is(targetType)) {
                    throw new DynamoDBMappingException("type [" + targetType + "] is not supported; not convertible from " + this);
                }
                converter = ConvertTo.ANY;
            }
            return converter;
        }

        final boolean is(Class<?> sourceType) {
            if (sourceType.isPrimitive()) {
                return this.primitiveType == sourceType;
            }
            return this.type.isAssignableFrom(sourceType);
        }

        final ScalarAttributeType scalarType() {
            return this.scalarType;
        }

        final <S> Class<S> type() {
            return this.type;
        }

        final <S> Class<S> primitiveType() {
            return this.primitiveType;
        }

        static final Scalar of(Class<?> sourceType) {
            for (Scalar scalar : Scalar.values()) {
                if (!scalar.is(sourceType)) continue;
                return scalar;
            }
            return DEFAULT;
        }
    }
}

