/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.directconnect.model.transform;

import com.amazonaws.SdkClientException;
import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.MarshallLocation;
import com.amazonaws.protocol.MarshallingInfo;
import com.amazonaws.protocol.MarshallingType;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.services.directconnect.model.VirtualInterface;
import java.util.List;

@SdkInternalApi
public class VirtualInterfaceMarshaller {
    private static final MarshallingInfo<String> OWNERACCOUNT_BINDING = MarshallingInfo.builder(MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("ownerAccount").build();
    private static final MarshallingInfo<String> VIRTUALINTERFACEID_BINDING = MarshallingInfo.builder(MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("virtualInterfaceId").build();
    private static final MarshallingInfo<String> LOCATION_BINDING = MarshallingInfo.builder(MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("location").build();
    private static final MarshallingInfo<String> CONNECTIONID_BINDING = MarshallingInfo.builder(MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("connectionId").build();
    private static final MarshallingInfo<String> VIRTUALINTERFACETYPE_BINDING = MarshallingInfo.builder(MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("virtualInterfaceType").build();
    private static final MarshallingInfo<String> VIRTUALINTERFACENAME_BINDING = MarshallingInfo.builder(MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("virtualInterfaceName").build();
    private static final MarshallingInfo<Integer> VLAN_BINDING = MarshallingInfo.builder(MarshallingType.INTEGER).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("vlan").build();
    private static final MarshallingInfo<Integer> ASN_BINDING = MarshallingInfo.builder(MarshallingType.INTEGER).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("asn").build();
    private static final MarshallingInfo<String> AUTHKEY_BINDING = MarshallingInfo.builder(MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("authKey").build();
    private static final MarshallingInfo<String> AMAZONADDRESS_BINDING = MarshallingInfo.builder(MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("amazonAddress").build();
    private static final MarshallingInfo<String> CUSTOMERADDRESS_BINDING = MarshallingInfo.builder(MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("customerAddress").build();
    private static final MarshallingInfo<String> ADDRESSFAMILY_BINDING = MarshallingInfo.builder(MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("addressFamily").build();
    private static final MarshallingInfo<String> VIRTUALINTERFACESTATE_BINDING = MarshallingInfo.builder(MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("virtualInterfaceState").build();
    private static final MarshallingInfo<String> CUSTOMERROUTERCONFIG_BINDING = MarshallingInfo.builder(MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("customerRouterConfig").build();
    private static final MarshallingInfo<String> VIRTUALGATEWAYID_BINDING = MarshallingInfo.builder(MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("virtualGatewayId").build();
    private static final MarshallingInfo<List> ROUTEFILTERPREFIXES_BINDING = MarshallingInfo.builder(MarshallingType.LIST).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("routeFilterPrefixes").build();
    private static final MarshallingInfo<List> BGPPEERS_BINDING = MarshallingInfo.builder(MarshallingType.LIST).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("bgpPeers").build();
    private static final VirtualInterfaceMarshaller instance = new VirtualInterfaceMarshaller();

    public static VirtualInterfaceMarshaller getInstance() {
        return instance;
    }

    public void marshall(VirtualInterface virtualInterface, ProtocolMarshaller protocolMarshaller) {
        if (virtualInterface == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        try {
            protocolMarshaller.marshall(virtualInterface.getOwnerAccount(), OWNERACCOUNT_BINDING);
            protocolMarshaller.marshall(virtualInterface.getVirtualInterfaceId(), VIRTUALINTERFACEID_BINDING);
            protocolMarshaller.marshall(virtualInterface.getLocation(), LOCATION_BINDING);
            protocolMarshaller.marshall(virtualInterface.getConnectionId(), CONNECTIONID_BINDING);
            protocolMarshaller.marshall(virtualInterface.getVirtualInterfaceType(), VIRTUALINTERFACETYPE_BINDING);
            protocolMarshaller.marshall(virtualInterface.getVirtualInterfaceName(), VIRTUALINTERFACENAME_BINDING);
            protocolMarshaller.marshall(virtualInterface.getVlan(), VLAN_BINDING);
            protocolMarshaller.marshall(virtualInterface.getAsn(), ASN_BINDING);
            protocolMarshaller.marshall(virtualInterface.getAuthKey(), AUTHKEY_BINDING);
            protocolMarshaller.marshall(virtualInterface.getAmazonAddress(), AMAZONADDRESS_BINDING);
            protocolMarshaller.marshall(virtualInterface.getCustomerAddress(), CUSTOMERADDRESS_BINDING);
            protocolMarshaller.marshall(virtualInterface.getAddressFamily(), ADDRESSFAMILY_BINDING);
            protocolMarshaller.marshall(virtualInterface.getVirtualInterfaceState(), VIRTUALINTERFACESTATE_BINDING);
            protocolMarshaller.marshall(virtualInterface.getCustomerRouterConfig(), CUSTOMERROUTERCONFIG_BINDING);
            protocolMarshaller.marshall(virtualInterface.getVirtualGatewayId(), VIRTUALGATEWAYID_BINDING);
            protocolMarshaller.marshall(virtualInterface.getRouteFilterPrefixes(), ROUTEFILTERPREFIXES_BINDING);
            protocolMarshaller.marshall(virtualInterface.getBgpPeers(), BGPPEERS_BINDING);
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), e);
        }
    }
}

